/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.cache.Cache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridCachePluginContext;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.CacheConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.CacheOsConflictResolutionManager;
import org.apache.ignite.internal.processors.cache.GridCacheManagerAdapter;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManagerImpl;
import org.apache.ignite.internal.processors.cache.dr.GridCacheDrManager;
import org.apache.ignite.internal.processors.cache.dr.GridOsCacheDrManager;
import org.apache.ignite.internal.processors.cache.store.CacheOsStoreManager;
import org.apache.ignite.internal.processors.cache.store.CacheStoreManager;
import org.apache.ignite.plugin.CachePluginContext;
import org.apache.ignite.plugin.CachePluginProvider;
import org.apache.ignite.plugin.PluginProvider;
import org.jetbrains.annotations.Nullable;

public class CachePluginManager
extends GridCacheManagerAdapter {
    private final List<CachePluginProvider> providersList = new ArrayList<CachePluginProvider>();
    private final Map<CachePluginContext, CachePluginProvider> providersMap = new HashMap<CachePluginContext, CachePluginProvider>();
    private final GridKernalContext ctx;
    private final CacheConfiguration cfg;

    public CachePluginManager(GridKernalContext ctx, CacheConfiguration cfg) {
        this.ctx = ctx;
        this.cfg = cfg;
        for (PluginProvider p : ctx.plugins().allProviders()) {
            GridCachePluginContext pluginCtx;
            CachePluginProvider provider = p.createCacheProvider(pluginCtx = new GridCachePluginContext(ctx, cfg));
            if (provider == null) continue;
            this.providersList.add(provider);
            this.providersMap.put(pluginCtx, provider);
        }
    }

    @Override
    protected void onKernalStart0() throws IgniteCheckedException {
        for (CachePluginProvider provider : this.providersList) {
            provider.onIgniteStart();
        }
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        for (int i = this.providersList.size() - 1; i >= 0; --i) {
            this.providersList.get(i).onIgniteStop(cancel);
        }
    }

    @Override
    protected void start0() throws IgniteCheckedException {
        for (CachePluginProvider provider : this.providersList) {
            provider.start();
        }
    }

    @Override
    protected void stop0(boolean cancel, boolean destroy) {
        for (int i = this.providersList.size() - 1; i >= 0; --i) {
            this.providersList.get(i).stop(cancel);
        }
    }

    public <T> T createComponent(Class<T> cls) {
        for (CachePluginProvider provider : this.providersList) {
            T res = provider.createComponent(cls);
            if (res == null) continue;
            return res;
        }
        if (cls.equals(GridCacheDrManager.class)) {
            return (T)new GridOsCacheDrManager();
        }
        if (cls.equals(CacheConflictResolutionManager.class)) {
            CacheConflictResolutionManager cmp = this.ctx.createComponent(CacheConflictResolutionManager.class);
            if (cmp != null) {
                return (T)cmp;
            }
            return (T)new CacheOsConflictResolutionManager();
        }
        if (cls.equals(CacheStoreManager.class)) {
            return (T)new CacheOsStoreManager(this.ctx, this.cfg);
        }
        if (cls.equals(IgniteCacheOffheapManager.class)) {
            return (T)new IgniteCacheOffheapManagerImpl();
        }
        throw new IgniteException("Unsupported component type: " + cls);
    }

    @Nullable
    public <T, K, V> T unwrapCacheEntry(Cache.Entry<K, V> entry, Class<T> cls) {
        for (int i = 0; i < this.providersList.size(); ++i) {
            T res = this.providersList.get(i).unwrapCacheEntry(entry, cls);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void validate() throws IgniteCheckedException {
        for (CachePluginProvider provider : this.providersList) {
            provider.validate();
        }
    }

    public void validateRemotes(CacheConfiguration rmtCfg, ClusterNode rmtNode) throws IgniteCheckedException {
        for (Map.Entry<CachePluginContext, CachePluginProvider> entry : this.providersMap.entrySet()) {
            CachePluginContext cctx = entry.getKey();
            CachePluginProvider provider = entry.getValue();
            provider.validateRemote(cctx.igniteCacheConfiguration(), rmtCfg, rmtNode);
        }
    }
}

