/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.memory;

import org.apache.ignite.internal.processors.platform.memory.PlatformInputStreamImpl;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;

public class PlatformBigEndianInputStreamImpl
extends PlatformInputStreamImpl {
    public PlatformBigEndianInputStreamImpl(PlatformMemory mem) {
        super(mem);
    }

    @Override
    public short readShort() {
        return Short.reverseBytes(super.readShort());
    }

    @Override
    public short[] readShortArray(int cnt) {
        short[] res = super.readShortArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Short.reverseBytes(res[i]);
        }
        return res;
    }

    @Override
    public char readChar() {
        return Character.reverseBytes(super.readChar());
    }

    @Override
    public char[] readCharArray(int cnt) {
        char[] res = super.readCharArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Character.reverseBytes(res[i]);
        }
        return res;
    }

    @Override
    public int readInt() {
        return Integer.reverseBytes(super.readInt());
    }

    @Override
    public byte readBytePositioned(int pos) {
        return super.readBytePositioned(pos);
    }

    @Override
    public short readShortPositioned(int pos) {
        return Short.reverseBytes(super.readShortPositioned(pos));
    }

    @Override
    public int readIntPositioned(int pos) {
        return Integer.reverseBytes(super.readIntPositioned(pos));
    }

    @Override
    public int[] readIntArray(int cnt) {
        int[] res = super.readIntArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Integer.reverseBytes(res[i]);
        }
        return res;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(super.readFloat())));
    }

    @Override
    public float[] readFloatArray(int cnt) {
        float[] res = super.readFloatArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToIntBits(res[i])));
        }
        return res;
    }

    @Override
    public long readLong() {
        return Long.reverseBytes(super.readLong());
    }

    @Override
    public long[] readLongArray(int cnt) {
        long[] res = super.readLongArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Long.reverseBytes(res[i]);
        }
        return res;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(super.readDouble())));
    }

    @Override
    public double[] readDoubleArray(int cnt) {
        double[] res = super.readDoubleArray(cnt);
        for (int i = 0; i < cnt; ++i) {
            res[i] = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToLongBits(res[i])));
        }
        return res;
    }
}

