/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.OpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;
import org.apache.ignite.internal.processors.compress.FileSystemUtils;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class AsyncFileIO
extends AbstractFileIO {
    private final AsynchronousFileChannel ch;
    private final int fd;
    private final int fsBlockSize;
    private volatile long position;
    private final ThreadLocal<ChannelOpFuture> holder;
    private GridConcurrentHashSet<ChannelOpFuture> asyncFuts = new GridConcurrentHashSet();

    public AsyncFileIO(File file, ThreadLocal<ChannelOpFuture> holder, OpenOption ... modes) throws IOException {
        this.ch = AsynchronousFileChannel.open(file.toPath(), modes);
        this.fd = AsyncFileIO.getFileDescriptor(this.ch);
        this.fsBlockSize = FileSystemUtils.getFileSystemBlockSize(this.fd);
        this.holder = holder;
    }

    private static int getFileDescriptor(AsynchronousFileChannel ch) {
        FileDescriptor fd = (FileDescriptor)U.field(ch, "fdObj");
        return (Integer)U.field(fd, "fd");
    }

    @Override
    public int getFileSystemBlockSize() {
        return this.fsBlockSize;
    }

    @Override
    public long getSparseSize() {
        return FileSystemUtils.getSparseFileSize(this.fd);
    }

    @Override
    public int punchHole(long position, int len) {
        return (int)FileSystemUtils.punchHole(this.fd, position, len, this.fsBlockSize);
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.position = newPosition;
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(destBuf, this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(destBuf, position, null, fut);
        try {
            int n = (Integer)fut.getUninterruptibly();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
        finally {
            this.asyncFuts.remove(fut);
        }
    }

    @Override
    public int read(byte[] buf, int off, int length) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.read(ByteBuffer.wrap(buf, off, length), this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.write(srcBuf, this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.asyncFuts.add(fut);
        this.ch.write(srcBuf, position, null, fut);
        try {
            int n = (Integer)fut.getUninterruptibly();
            return n;
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
        finally {
            this.asyncFuts.remove(fut);
        }
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        ChannelOpFuture fut = this.holder.get();
        fut.reset();
        this.ch.write(ByteBuffer.wrap(buf, off, len), this.position, this, fut);
        try {
            return (Integer)fut.getUninterruptibly();
        }
        catch (IgniteCheckedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        throw new UnsupportedOperationException("AsynchronousFileChannel doesn't support mmap.");
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.ch.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.ch.size();
    }

    @Override
    public void clear() throws IOException {
        this.ch.truncate(0L);
        this.position = 0L;
    }

    @Override
    public void close() throws IOException {
        for (ChannelOpFuture asyncFut : this.asyncFuts) {
            try {
                asyncFut.getUninterruptibly();
            }
            catch (IgniteCheckedException e) {
                throw new IOException(e);
            }
        }
        this.ch.close();
    }

    static class ChannelOpFuture
    extends GridFutureAdapter<Integer>
    implements CompletionHandler<Integer, AsyncFileIO> {
        ChannelOpFuture() {
        }

        @Override
        public void completed(Integer res, AsyncFileIO attach) {
            if (attach != null && res != -1) {
                attach.position += (long)res.intValue();
            }
            super.onDone(res, null);
        }

        @Override
        public void failed(Throwable exc, AsyncFileIO attach) {
            super.onDone(exc);
        }
    }
}

