/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RowHandler;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeCondition;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewColumnDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.SystemViewTableDescriptorImpl;
import org.apache.ignite.internal.processors.query.calcite.util.TypeUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.jetbrains.annotations.Nullable;

public class SystemViewScan<Row, ViewRow>
implements Iterable<Row> {
    private final ExecutionContext<Row> ectx;
    private final SystemViewTableDescriptorImpl<ViewRow> desc;
    private final RowHandler.RowFactory<Row> factory;
    private final RangeIterable<Row> ranges;
    private final ImmutableBitSet requiredColumns;
    private final String[] filterableFieldNames;
    private final Class<?>[] filterableFieldTypes;

    public SystemViewScan(ExecutionContext<Row> ectx, SystemViewTableDescriptorImpl<ViewRow> desc, @Nullable RangeIterable<Row> ranges, @Nullable ImmutableBitSet requiredColumns) {
        this.ectx = ectx;
        this.desc = desc;
        this.ranges = ranges;
        this.requiredColumns = requiredColumns;
        RelDataType rowType = desc.rowType(ectx.getTypeFactory(), requiredColumns);
        this.factory = ectx.rowHandler().factory(ectx.getTypeFactory(), rowType);
        this.filterableFieldNames = new String[desc.columnDescriptors().size()];
        this.filterableFieldTypes = new Class[desc.columnDescriptors().size()];
        if (desc.isFiltrable()) {
            for (SystemViewColumnDescriptor col : desc.columnDescriptors()) {
                if (!col.isFiltrable()) continue;
                this.filterableFieldNames[col.fieldIndex()] = col.originalName();
                this.filterableFieldTypes[col.fieldIndex()] = col.storageType();
            }
        }
    }

    @Override
    public Iterator<Row> iterator() {
        Iterator viewIter;
        SystemView<ViewRow> view = this.desc.systemView();
        if (this.ranges != null) {
            assert (view instanceof FiltrableSystemView) : view;
            Iterator rangesIter = this.ranges.iterator();
            RangeCondition range = (RangeCondition)rangesIter.next();
            assert (!rangesIter.hasNext());
            Object searchValues = range.lower();
            RowHandler rowHnd = this.ectx.rowHandler();
            HashMap<String, Object> filterMap = null;
            for (int i = 0; i < this.filterableFieldNames.length; ++i) {
                Object val;
                if (this.filterableFieldNames[i] == null || (val = rowHnd.get(i, searchValues)) == this.ectx.unspecifiedValue()) continue;
                if (filterMap == null) {
                    filterMap = new HashMap<String, Object>();
                }
                filterMap.put(this.filterableFieldNames[i], TypeUtils.fromInternal(this.ectx, val, this.filterableFieldTypes[i]));
            }
            viewIter = F.isEmpty(filterMap) ? view.iterator() : ((FiltrableSystemView)view).iterator(filterMap);
        } else {
            viewIter = view.iterator();
        }
        return F.iterator((Iterator)viewIter, (IgniteClosure & Serializable)row -> this.desc.toRow(this.ectx, row, this.factory, this.requiredColumns), (boolean)true, (IgnitePredicate[])new IgnitePredicate[0]);
    }
}

