/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.resource;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.managers.deployment.GridDeployment;
import org.apache.ignite.internal.processors.resource.GridResourceField;
import org.apache.ignite.internal.processors.resource.GridResourceInjector;
import org.apache.ignite.internal.processors.resource.GridResourceMethod;
import org.apache.ignite.internal.processors.resource.GridResourceUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.resources.SpringResource;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class GridResourceSpringBeanInjector
implements GridResourceInjector {
    private ApplicationContext springCtx;

    public GridResourceSpringBeanInjector(ApplicationContext springCtx) {
        this.springCtx = springCtx;
    }

    public void inject(GridResourceField field, Object target, Class<?> cls, GridDeployment depCls) throws IgniteCheckedException {
        Object bean;
        SpringResource ann = (SpringResource)field.getAnnotation();
        assert (ann != null);
        if (!Modifier.isTransient(field.getField().getModifiers()) && Serializable.class.isAssignableFrom(field.getField().getDeclaringClass())) {
            throw new IgniteCheckedException("@SpringResource must only be used with 'transient' fields: " + field.getField());
        }
        if (this.springCtx != null && (bean = this.getBeanByResourceAnnotation(ann)) != null) {
            GridResourceUtils.inject((Field)field.getField(), (Object)target, (Object)bean);
        }
    }

    public void inject(GridResourceMethod mtd, Object target, Class<?> cls, GridDeployment depCls) throws IgniteCheckedException {
        Object bean;
        SpringResource ann = (SpringResource)mtd.getAnnotation();
        assert (ann != null);
        if (mtd.getMethod().getParameterTypes().length != 1) {
            throw new IgniteCheckedException("Method injection setter must have only one parameter: " + mtd.getMethod());
        }
        if (this.springCtx != null && (bean = this.getBeanByResourceAnnotation(ann)) != null) {
            GridResourceUtils.inject((Method)mtd.getMethod(), (Object)target, (Object)bean);
        }
    }

    public void undeploy(GridDeployment dep) {
    }

    public String toString() {
        return S.toString(GridResourceSpringBeanInjector.class, (Object)this);
    }

    private Object getBeanByResourceAnnotation(SpringResource annotation) throws IgniteCheckedException {
        assert (this.springCtx != null);
        String beanName = annotation.resourceName();
        Class beanCls = annotation.resourceClass();
        boolean oneParamSet = !StringUtils.isEmpty((Object)beanName) ^ beanCls != SpringResource.DEFAULT.class;
        if (!oneParamSet) {
            throw new IgniteCheckedException("Either bean name or its class must be specified in @SpringResource, but not both");
        }
        try {
            return !StringUtils.isEmpty((Object)beanName) ? this.springCtx.getBean(beanName) : this.springCtx.getBean(beanCls);
        }
        catch (NoUniqueBeanDefinitionException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            if (!annotation.required()) {
                return null;
            }
            throw e;
        }
    }
}

