/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.jdbc;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.yardstick.IgniteAbstractBenchmark;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class NativeSqlJoinQueryRangeBenchmark
extends IgniteAbstractBenchmark {
    GridQueryProcessor qry;

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long expRsSize;
        SqlFieldsQuery qry;
        if (this.args.sqlRange() == 1) {
            qry = new SqlFieldsQuery("SELECT * FROM person p join organization o on p.orgId=o.id WHERE p.id = ? order by p.id");
            qry.setArgs(new Object[]{ThreadLocalRandom.current().nextLong(this.args.range())});
            expRsSize = 1L;
        } else if (this.args.sqlRange() <= 0) {
            qry = new SqlFieldsQuery("SELECT * FROM person p join organization o on p.orgId=o.id order by p.id LIMIT 1000");
            expRsSize = 1000L;
        } else {
            qry = new SqlFieldsQuery("SELECT * FROM person p join organization o on p.orgId=o.id WHERE p.id BETWEEN ? AND ?order by p.id");
            long id = ThreadLocalRandom.current().nextLong(this.args.range() - this.args.sqlRange());
            long maxId = id + (long)this.args.sqlRange() - 1L;
            qry.setArgs(new Object[]{id, maxId});
            expRsSize = this.args.sqlRange();
        }
        long rsSize = 0L;
        try (FieldsQueryCursor cursor = ((IgniteEx)this.ignite()).context().query().querySqlFields(qry, false);){
            for (List r : cursor) {
                ++rsSize;
            }
        }
        if (rsSize != expRsSize) {
            throw new Exception("Invalid result set size [actual=" + rsSize + ", expected=" + expRsSize + ", qry=" + qry + "]");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        IgniteSemaphore sem = this.ignite().semaphore("sql-setup", 1, true, true);
        try {
            if (sem.tryAcquire()) {
                this.qry = ((IgniteEx)this.ignite()).context().query();
                StringBuilder withExpr = new StringBuilder(" WITH \"AFFINITY_KEY=orgId,");
                if (this.args.atomicMode() != null) {
                    withExpr.append("atomicity=").append(this.args.atomicMode().name()).append(",");
                }
                if (this.args.partitionedCachesNumber() == 1) {
                    withExpr.append("template=replicated");
                } else {
                    withExpr.append("template=partitioned");
                }
                withExpr.append("\"");
                this.qry.querySqlFields(new SqlFieldsQuery("CREATE TABLE person (id long, orgId long, name varchar, PRIMARY KEY (id, orgId))" + withExpr), true);
                withExpr = new StringBuilder(" WITH \"");
                if (this.args.atomicMode() != null) {
                    withExpr.append("atomicity=").append(this.args.atomicMode().name()).append(",");
                }
                withExpr.append("template=partitioned");
                withExpr.append("\"");
                this.qry.querySqlFields(new SqlFieldsQuery("CREATE TABLE organization (id long primary key, name varchar)" + withExpr), true);
                for (long k = 0L; k <= (long)this.args.range(); ++k) {
                    this.qry.querySqlFields(new SqlFieldsQuery("insert into person (id, orgId, name) values (?, ?, ?)").setArgs(new Object[]{k, k / 10L, "person " + k}), true).getAll();
                    if (k % 10L == 0L) {
                        this.qry.querySqlFields(new SqlFieldsQuery("insert into organization (id, name) values (?, ?)").setArgs(new Object[]{k / 10L, "organization " + k / 10L}), true).getAll();
                    }
                    if (k % 10000L != 0L) continue;
                    BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populate " + k));
                }
            } else {
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Waits for setup...");
                sem.acquire();
            }
        }
        finally {
            sem.release();
        }
    }
}

