/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache.failover;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.yardstick.IgniteNode;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteFailoverNode
extends IgniteNode {
    @Override
    public void start(BenchmarkConfiguration cfg) throws Exception {
        super.start(cfg);
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        List<String> jvmOpts = mxBean.getInputArguments();
        StringBuilder jvmOptsStr = new StringBuilder();
        for (String opt : jvmOpts) {
            jvmOptsStr.append(opt).append(' ');
        }
        cfg.customProperties().put("JVM_OPTS", jvmOptsStr.toString());
        cfg.customProperties().put("PROPS_ENV", System.getenv("PROPS_ENV"));
        cfg.customProperties().put("CLASSPATH", mxBean.getClassPath());
        cfg.customProperties().put("JAVA", System.getenv("JAVA"));
        IgniteCache srvsCfgsCache = this.ignite().getOrCreateCache(new CacheConfiguration().setName("serversConfigs"));
        srvsCfgsCache.put((Object)cfg.memberId(), (Object)cfg);
        BenchmarkUtils.println((String)("Put at cache [" + cfg.memberId() + "=" + cfg + "]"));
    }
}

