/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.IgniteTransactions;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.transactions.Transaction;
import org.apache.ignite.transactions.TransactionMetrics;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.WaitMapExchangeFinishCallable;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgnitePutTxLoadBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    private ArrayList<IgniteCache<Object, Object>> cacheList;
    private String val;
    private Random random;

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        if (!IgniteSystemProperties.getBoolean((String)"SKIP_MAP_CHECK")) {
            this.ignite().compute().broadcast((IgniteCallable)new WaitMapExchangeFinishCallable());
        }
        this.cacheList = new ArrayList(this.args.cachesCount());
        for (int i = 0; i < this.args.cachesCount(); ++i) {
            this.cacheList.add((IgniteCache<Object, Object>)this.ignite().cache("tx-" + i));
        }
        this.val = this.createVal(this.args.getStringLength());
        this.random = new Random();
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        long endTime;
        long startTime;
        IgniteTransactions transactions = this.ignite().transactions();
        try (Transaction tx = transactions.txStart(this.args.txConcurrency(), this.args.txIsolation());){
            int i;
            ArrayList<Long> keyList = new ArrayList<Long>(this.args.scaleFactor());
            for (i = 0; i < this.args.scaleFactor(); ++i) {
                keyList.add(this.random.nextLong());
            }
            Collections.sort(keyList);
            for (i = 0; i < this.args.scaleFactor(); ++i) {
                IgniteCache<Object, Object> curCache = this.cacheList.get(this.random.nextInt(this.cacheList.size()));
                curCache.put(keyList.get(i), (Object)this.val);
            }
            startTime = System.currentTimeMillis();
            tx.commit();
            endTime = System.currentTimeMillis();
        }
        TransactionMetrics tm = transactions.metrics();
        if (endTime - startTime > this.args.getWarningTime()) {
            BenchmarkUtils.println((String)("Transaction commit time = " + (endTime - startTime)));
        }
        if (tm.txRollbacks() > 0 && this.args.printRollBacks()) {
            BenchmarkUtils.println((String)("Transaction rollbacks = " + tm.txRollbacks()));
        }
        return true;
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("tx");
    }

    private String createVal(int lgth) {
        StringBuilder sb = new StringBuilder(lgth);
        for (int i = 0; i < lgth; ++i) {
            sb.append('x');
        }
        return sb.toString();
    }
}

