/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.zk.internal.ZkAbstractWatcher;
import org.apache.ignite.spi.discovery.zk.internal.ZkClusterNodes;
import org.apache.ignite.spi.discovery.zk.internal.ZkIgnitePaths;
import org.apache.ignite.spi.discovery.zk.internal.ZkRuntimeState;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClient;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperDiscoveryImpl;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class ZkDistributedCollectDataFuture
extends GridFutureAdapter<Void> {
    private final IgniteLogger log;
    private final String futPath;
    private final Set<Long> remainingNodes;
    private final Callable<Void> lsnr;

    ZkDistributedCollectDataFuture(ZookeeperDiscoveryImpl impl, ZkRuntimeState rtState, String futPath, Callable<Void> lsnr) throws Exception {
        this.log = impl.log();
        this.futPath = futPath;
        this.lsnr = lsnr;
        ZkClusterNodes top = rtState.top;
        this.remainingNodes = U.newHashSet((int)top.nodesByOrder.size());
        for (ZookeeperClusterNode node : top.nodesByInternalId.values()) {
            this.remainingNodes.add(node.order());
        }
        NodeResultsWatcher watcher = new NodeResultsWatcher(rtState, impl);
        if (this.remainingNodes.isEmpty()) {
            this.completeAndNotifyListener();
        } else {
            if (this.log.isInfoEnabled()) {
                this.log.info("Initialize data collect future [futPath=" + futPath + ", remainingNodes=" + this.remainingNodes.size() + "]");
            }
            rtState.zkClient.getChildrenAsync(futPath, watcher, watcher);
        }
    }

    private void completeAndNotifyListener() throws Exception {
        if (super.onDone()) {
            this.lsnr.call();
        }
    }

    static void saveNodeResult(String futPath, ZookeeperClient client, long nodeOrder, byte[] data) throws Exception {
        client.createIfNeeded(futPath + "/" + nodeOrder, data, CreateMode.PERSISTENT);
    }

    static byte[] readNodeResult(String futPath, ZookeeperClient client, long nodeOrder) throws Exception {
        return client.getData(futPath + "/" + nodeOrder);
    }

    static void saveResult(String futResPath, ZookeeperClient client, byte[] data) throws Exception {
        client.createIfNeeded(futResPath, data, CreateMode.PERSISTENT);
    }

    static byte[] readResult(ZookeeperClient client, ZkIgnitePaths paths, UUID futId) throws Exception {
        return client.getData(paths.distributedFutureResultPath(futId));
    }

    static void deleteFutureData(ZookeeperClient client, ZkIgnitePaths paths, UUID futId, IgniteLogger log) throws Exception {
        LinkedList<String> batch = new LinkedList<String>();
        String evtDir = paths.distributedFutureBasePath(futId);
        if (client.exists(evtDir)) {
            batch.addAll(client.getChildrenPaths(evtDir));
            batch.add(evtDir);
        }
        batch.add(paths.distributedFutureResultPath(futId));
        client.deleteAll(batch, -1);
    }

    void onTopologyChange(ZkClusterNodes top) throws Exception {
        if (this.remainingNodes.isEmpty()) {
            return;
        }
        Iterator<Long> it = this.remainingNodes.iterator();
        while (it.hasNext()) {
            Long nodeOrder = it.next();
            if (top.nodesByOrder.containsKey(nodeOrder)) continue;
            it.remove();
            int remaining = this.remainingNodes.size();
            if (this.log.isInfoEnabled()) {
                this.log.info("ZkDistributedCollectDataFuture removed remaining failed node [node=" + nodeOrder + ", remaining=" + remaining + ", futPath=" + this.futPath + "]");
            }
            if (remaining != 0) continue;
            this.completeAndNotifyListener();
            break;
        }
    }

    class NodeResultsWatcher
    extends ZkAbstractWatcher
    implements AsyncCallback.Children2Callback {
        NodeResultsWatcher(ZkRuntimeState rtState, ZookeeperDiscoveryImpl impl) {
            super(rtState, impl);
        }

        @Override
        protected void process0(WatchedEvent evt) {
            if (evt.getType() == Watcher.Event.EventType.NodeChildrenChanged) {
                this.rtState.zkClient.getChildrenAsync(evt.getPath(), this, this);
            }
        }

        public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
            if (!this.onProcessStart()) {
                return;
            }
            try {
                if (!ZkDistributedCollectDataFuture.this.isDone()) {
                    assert (rc == 0) : KeeperException.Code.get((int)rc);
                    for (int i = 0; i < children.size(); ++i) {
                        Long nodeOrder = Long.parseLong(children.get(i));
                        if (!ZkDistributedCollectDataFuture.this.remainingNodes.remove(nodeOrder)) continue;
                        int remaining = ZkDistributedCollectDataFuture.this.remainingNodes.size();
                        if (ZkDistributedCollectDataFuture.this.log.isInfoEnabled()) {
                            ZkDistributedCollectDataFuture.this.log.info("ZkDistributedCollectDataFuture added new result [node=" + nodeOrder + ", remaining=" + remaining + ", futPath=" + path + "]");
                        }
                        if (remaining != 0) continue;
                        ZkDistributedCollectDataFuture.this.completeAndNotifyListener();
                    }
                }
                this.onProcessEnd();
            }
            catch (Throwable e) {
                this.onProcessError(e);
            }
        }
    }
}

