/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.GridCacheContextInfo;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptorImpl;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryField;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.H2IndexFactory;
import org.apache.ignite.internal.processors.query.h2.H2PooledConnection;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableEngine;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.QueryTable;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ProxyIndex;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sys.SqlSystemTableEngine;
import org.apache.ignite.internal.processors.query.h2.sys.view.FiltrableSystemViewLocal;
import org.apache.ignite.internal.processors.query.h2.sys.view.SystemViewLocal;
import org.apache.ignite.internal.processors.query.schema.SchemaChangeListener;
import org.apache.ignite.internal.processors.query.schema.management.IndexDescriptor;
import org.apache.ignite.internal.processors.query.schema.management.SchemaManager;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.systemview.view.FiltrableSystemView;
import org.apache.ignite.spi.systemview.view.SystemView;
import org.h2.index.Index;
import org.jetbrains.annotations.Nullable;

public class H2SchemaManager
implements SchemaChangeListener {
    private final ConnectionManager connMgr;
    private final ConcurrentMap<QueryTable, GridH2Table> dataTables = new ConcurrentHashMap<QueryTable, GridH2Table>();
    private final GridKernalContext ctx;
    private final IgniteH2Indexing idx;
    private final H2IndexFactory idxFactory;
    private final IgniteLogger log;
    private volatile SchemaManager schemaMgr;

    public H2SchemaManager(GridKernalContext ctx, IgniteH2Indexing idx, ConnectionManager connMgr) {
        this.ctx = ctx;
        this.idx = idx;
        this.connMgr = connMgr;
        this.idxFactory = new H2IndexFactory(ctx);
        this.log = ctx.log(H2SchemaManager.class);
    }

    public void start() throws IgniteCheckedException {
        this.schemaMgr = this.ctx.query().schemaManager();
        this.ctx.internalSubscriptionProcessor().registerSchemaChangeListener((SchemaChangeListener)this);
        this.createSqlFunction("PUBLIC", "QUERY_ENGINE", true, H2Utils.class.getName() + ".queryEngine");
    }

    public void onSchemaCreated(String schema) {
        try {
            this.connMgr.executeSystemStatement("CREATE SCHEMA IF NOT EXISTS " + H2Utils.withQuotes(schema));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Created H2 schema for index database: " + schema);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to create database schema: " + schema, (Throwable)e);
        }
    }

    public void onSchemaDropped(String schema) {
        try {
            this.connMgr.executeSystemStatement("DROP SCHEMA IF EXISTS " + H2Utils.withQuotes(schema));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Dropped H2 schema for index database: " + schema);
            }
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to drop database schema: " + schema, (Throwable)e);
        }
    }

    public void onSqlTypeCreated(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo) {
        H2TableDescriptor tblDesc = new H2TableDescriptor(this.idx, schemaName, typeDesc, cacheInfo);
        try (H2PooledConnection conn = this.connMgr.connection(schemaName);){
            GridH2Table h2tbl = this.createTable(tblDesc, conn);
            if (this.dataTables.putIfAbsent(h2tbl.identifier(), h2tbl) != null) {
                throw new IllegalStateException("Table already exists: " + h2tbl.identifierString());
            }
        }
        catch (SQLException e) {
            throw new IgniteException("Failed to register query type: " + tblDesc, (Throwable)e);
        }
    }

    private GridH2Table createTable(H2TableDescriptor tbl, H2PooledConnection conn) throws SQLException {
        assert (tbl != null);
        String sql = H2Utils.tableCreateSql(tbl);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Creating DB table with SQL: " + sql);
        }
        GridH2RowDescriptor rowDesc = new GridH2RowDescriptor((GridQueryRowDescriptor)new GridQueryRowDescriptorImpl(tbl.cacheInfo(), tbl.type()));
        return H2TableEngine.createTable(conn.connection(), sql, rowDesc, tbl, this.ctx.indexProcessor());
    }

    public void onSqlTypeDropped(String schemaName, GridQueryTypeDescriptor typeDesc, boolean destroy) {
        GridH2Table tbl = this.dataTable(schemaName, typeDesc.tableName());
        if (tbl == null) {
            throw new IgniteException("Failed to drop database table (table not found) [schemaName=" + schemaName + ", tblName=" + typeDesc.tableName() + "]");
        }
        this.dropTable(tbl.tableDescriptor());
        this.dataTables.remove(tbl.identifier(), (Object)tbl);
    }

    private void dropTable(H2TableDescriptor tbl) {
        assert (tbl != null);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing query index table: " + tbl.fullTableName());
        }
        try (H2PooledConnection c = this.connMgr.connection(tbl.schemaName());){
            Statement stmt = null;
            try {
                stmt = c.connection().createStatement();
                String sql = "DROP TABLE IF EXISTS " + tbl.fullTableName();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Dropping database index table with SQL: " + sql);
                }
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                throw new IgniteSQLException("Failed to drop database table [type=" + tbl.type().name() + ", table=" + tbl.fullTableName() + "]", 3004, (Throwable)e);
            }
            finally {
                U.close((AutoCloseable)stmt, (IgniteLogger)this.log);
            }
        }
        tbl.onDrop();
    }

    public void onFunctionCreated(String schema, String name, boolean deterministic, Method method) {
        try {
            this.createSqlFunction(schema, name, deterministic, method.getDeclaringClass().getName() + "." + method.getName());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to create database function: " + name, (Throwable)e);
        }
    }

    private void createSqlFunction(String schema, String alias, boolean deterministic, String methodName) throws IgniteCheckedException {
        String clause = "CREATE ALIAS IF NOT EXISTS " + alias + (deterministic ? " DETERMINISTIC FOR \"" : " FOR \"") + methodName + "\"";
        this.connMgr.executeStatement(schema, clause);
    }

    public void onSystemViewCreated(String schema, SystemView<?> view) {
        SystemViewLocal sysView = view instanceof FiltrableSystemView ? new FiltrableSystemViewLocal(this.ctx, view) : new SystemViewLocal(this.ctx, view);
        try (H2PooledConnection c = this.connMgr.connection(schema);){
            SqlSystemTableEngine.registerView(c.connection(), sysView);
        }
        catch (SQLException e) {
            throw new IgniteException("Failed to register system view: " + view.name(), (Throwable)e);
        }
    }

    public void onIndexCreated(String schemaName, String tblName, String idxName, IndexDescriptor idxDesc) {
        GridH2Table tbl = this.dataTable(schemaName, tblName);
        if (tbl == null) {
            return;
        }
        try {
            Index h2Idx = this.idxFactory.createIndex(tbl, idxDesc);
            if (H2SchemaManager.isSystemIndex(h2Idx)) {
                tbl.addSystemIndex(h2Idx);
                return;
            }
            tbl.proposeUserIndex(h2Idx);
            try {
                String sql = H2Utils.indexCreateSql(tbl.tableDescriptor().fullTableName(), h2Idx, true);
                this.connMgr.executeStatement(schemaName, sql);
            }
            catch (Exception e) {
                tbl.rollbackUserIndex(h2Idx.getName());
                throw e;
            }
        }
        catch (Exception e) {
            throw new IgniteException("Failed to register index in internal H2 database: " + idxName, (Throwable)e);
        }
    }

    private static boolean isSystemIndex(Index idx) {
        return "_key_PK".equals(idx.getName()) || "AFFINITY_KEY".equals(idx.getName()) || idx instanceof GridH2ProxyIndex && H2SchemaManager.isSystemIndex(((GridH2ProxyIndex)idx).underlyingIndex());
    }

    public void onIndexDropped(String schemaName, String tblName, String idxName) {
        GridH2Table tbl = this.dataTable(schemaName, tblName);
        if (tbl == null) {
            return;
        }
        Index idx = (Index)F.find(tbl.getIndexes(), null, (IgnitePredicate[])new IgnitePredicate[]{(IgnitePredicate & Serializable)i -> idxName.equals(i.getName())});
        if (idx == null) {
            return;
        }
        if (H2SchemaManager.isSystemIndex(idx)) {
            tbl.removeIndex(idx);
            return;
        }
        String sql = H2Utils.indexDropSql(schemaName, idxName, true);
        try {
            this.connMgr.executeStatement(schemaName, sql);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to unregister index: " + idxName, (Throwable)e);
        }
    }

    public void onColumnsAdded(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<QueryField> cols) {
        GridH2Table tbl = this.dataTable(schemaName, typeDesc.tableName());
        if (tbl == null) {
            return;
        }
        tbl.addColumns(cols);
    }

    public void onColumnsDropped(String schemaName, GridQueryTypeDescriptor typeDesc, GridCacheContextInfo<?, ?> cacheInfo, List<String> cols) {
        GridH2Table tbl = this.dataTable(schemaName, typeDesc.tableName());
        if (tbl == null) {
            return;
        }
        tbl.dropColumns(cols);
    }

    public void onIndexRebuildStarted(String schemaName, String tblName) {
        GridH2Table tbl = this.dataTable(schemaName, tblName);
        if (tbl != null) {
            tbl.markRebuildFromHashInProgress(true);
        }
    }

    public void onIndexRebuildFinished(String schemaName, String tblName) {
        GridH2Table tbl = this.dataTable(schemaName, tblName);
        if (tbl != null) {
            tbl.markRebuildFromHashInProgress(false);
        }
    }

    public void onViewCreated(String schemaName, String viewName, String viewSql) {
        try (H2PooledConnection conn = this.connMgr.connection(schemaName);
             Statement s = conn.connection().createStatement();){
            s.execute("CREATE OR REPLACE VIEW \"" + viewName + "\" AS " + viewSql);
        }
        catch (SQLException e) {
            throw new IgniteException("Failed to create view: " + viewName, (Throwable)e);
        }
    }

    public void onViewDropped(String schemaName, String viewName) {
        try (H2PooledConnection conn = this.connMgr.connection(schemaName);
             Statement s = conn.connection().createStatement();){
            s.execute("DROP VIEW IF EXISTS \"" + viewName + "\"");
        }
        catch (SQLException e) {
            throw new IgniteException("Failed to drop view: " + viewName, (Throwable)e);
        }
    }

    @Nullable
    public H2TableDescriptor tableForType(String schemaName, String cacheName, String type) {
        GridH2Table tbl;
        GridQueryTypeDescriptor typeDesc = this.schemaMgr.typeDescriptorForType(schemaName, cacheName, type);
        if (typeDesc != null && (tbl = this.dataTable(schemaName, typeDesc.tableName())) != null) {
            return tbl.tableDescriptor();
        }
        return null;
    }

    public GridH2Table dataTable(String schemaName, String tblName) {
        return (GridH2Table)((Object)this.dataTables.get(new QueryTable(schemaName, tblName)));
    }
}

