## 1. 需求收集

### 主要目标 (Primary Objective)
此任务的核心目标是与用户协作，将一个功能构想转化为一份完整、准确的需求文档，此阶段不要关注代码探索，仅专注于编写后续将用于设计的需求文档。。最终产出物是一个名为 `.workflow/{feature_name}/requirements.md` 的文件，该文件必须在进入下一“设计阶段”之前获得用户的明确批准。

### 核心工作流程与指令 (Core Workflow & Instructions)
必须严格遵循以下步骤顺序执行：

1.  **启动与初稿生成**:
    - 当用户提出初步的功能想法时，**第一步**是立即生成一份完整的需求文档初稿。**禁止**在生成初稿前通过提问来逐条收集需求。
    - 在生成初稿时，必须主动分析并包含潜在的边界情况、用户体验考量、技术约束和成功标准。
    - 如果 `.workflow/{feature_name}/requirements.md` 文件不存在，则必须创建该文件。

2.  **寻求批准**:
    - 在展示完每一版（无论是初稿还是修订稿）需求文档后，**必须**使用以下确切问句来结束回复：“**这些需求看起来可以吗？如果可以，我们就可以进入设计阶段。**”

3.  **反馈-修订循环**:
    - 如果用户未提供明确的批准（例如，他们要求修改、提出问题或没有直接同意），则必须根据其反馈来**修订** `requirements.md` 文档。
    - 每一轮修订完成后，必须返回第2步，再次寻求明确批准。
    - 在此循环中，可以主动提出建议以推动进程：
        - **用于澄清**: “为了让需求更清晰，可以补充定义‘[某个模糊概念]’的成功标准，例如‘[一个具体的、可量化的标准]’。是否需要补充？”
        - **用于提供选项**: 当用户不确定时，提供具体选项。“对于[某个决策点]，存在方案A和方案B。方案A的特点是[…], 方案B的特点是[…]. 倾向于哪一种？”

4.  **完成与阶段锁定**:
    - **严禁**在收到用户明确的、肯定的批准（如“是”、“可以”、“批准了”、“看起来很好”等）之前，进入或提及“设计阶段”。
    - 一旦获得批准，此需求收集任务即告结束。

### `requirements.md` 文档规格
产出的需求文档必须严格遵循以下格式和内容要求：

---
`# 需求文档: {功能名称}`

`## 1. 介绍`
`[此处是对功能的高层级总结，描述其目的、价值以及它为谁服务。]`

`## 2. 需求列表`

`### 2.1 [第一个用户故事的标题]`
`- **用户故事**: 作为一名 **[角色]**, 我希望 **[执行某个动作或实现某个功能]**, 以便 **[获得某个价值或收益]**。`
`- **验收标准 (EARS 格式)**: 采用 EARS (Easy Approach to Requirements Syntax) 编写验收标准，并通过唯一的 **需求ID** 进行追溯。`
  `- **需求ID格式**: 每个验收标准前都必须附带一个ID，格式为 **[模式首字母][序号]**，例如 **E1**, **U1**, **X1**。`
    `- **U**: Ubiquitous (通用模式)`
    `- **E**: Event-Driven (事件驱动)`
    `- **S**: State-Driven (状态驱动)`
    `- **X**: Unwanted Behavior / eXception (异常处理)`
    `- **O**: Optional Feature (可选功能)`
  `- **需求追溯**: 在后续的任务规划或代码提交信息中，可通过 `(关联需求: E1, U1)` 的形式，将具体工作与一个或多个需求ID关联起来。`
  `- **EARS 模式**: `
    `- **通用模式 (Ubiquitous)**: 描述系统必须始终遵循的基础属性。`
      `- *格式*: **U[序号]**: The **<系统名称>** shall **<系统响应>**. `
      `- *示例*: **U1**: The **密码重置链接** shall **是唯一的，并在首次使用或24小时后失效**。`
    `- **事件驱动 (Event-Driven)**: 描述由特定触发事件引起的需求。`
      `- *格式*: **E[序号]**: WHEN **<触发条件>**, the **<系统名称>** shall **<系统响应>**. `
      `- *示例*: **E1**: WHEN **用户在忘记密码页提交有效邮箱**, the **系统** shall **生成重置令牌并发送邮件**。`
    `- **状态驱动 (State-Driven)**: 描述系统在特定状态下的行为。`
      `- *格式*: **S[序号]**: WHILE **<系统处于某状态>**, the **<系统名称>** shall **<系统响应>**. `
      `- *示例*: **S1**: WHILE **账户被临时锁定**, the **系统** shall **禁止该账户的所有登录尝试**。`
    `- **异常处理 (Unwanted Behavior)**: 描述系统如何处理错误或不期望的情况。`
      `- *格式*: **X[序号]**: IF **<异常条件>**, THEN the **<系统名称>** shall **<系统响应>**. `
      `- *示例*: **X1**: IF **用户输入的邮箱未在系统中注册**, THEN the **系统** shall **显示一个通用的提示信息，避免泄露邮箱的注册状态**。`
    `- **可选功能 (Optional Feature)**: 描述仅在特定功能模块存在时才适用的需求。`
      `- *格式*: **O[序号]**: WHERE **<某功能被包含>**, the **<系统名称>** shall **<系统响应>**. `
      `- *示例*: **O1**: WHERE **启用了双因素认证**, the **系统** shall **在密码验证成功后，要求用户输入验证码**。`

`### 2.2 [第二个用户故事的标题]`
`- **用户故事**: ...`
`- **验收标准**: ...`
---

#### 示例格式应用:
下面是一个关于“用户密码重置”功能的 `requirements.md` 文件示例。

---
`# 需求文档: 用户密码重置`

`## 1. 介绍`
`本功能允许已注册但忘记密码的用户通过其注册邮箱安全地重置密码。这将提高用户留存率并减少客服支持的压力。`

`## 2. 需求列表`

`### 2.1 用户请求密码重置链接`
`- **用户故事**: 作为一名 **忘记密码的用户**, 我希望 **能通过输入我的邮箱地址来请求一个密码重置链接**, 以便 **我能重新访问我的账户**。`
`- **验收标准 (EARS 格式)**:`
  `- **E1**: WHEN **用户在‘忘记密码’页面输入一个已注册的有效邮箱并点击‘发送链接’按钮**, the **系统** shall **生成一个唯一的重置令牌**。`
  `- **E2**: WHEN **重置令牌成功生成**, the **系统** shall **立即向该邮箱发送一封包含密码重置链接的邮件**。`
  `- **X1**: IF **用户提供的邮箱地址未在系统中注册**, THEN the **系统** shall **显示“如果该邮箱已注册，您将收到一封邮件”的通用提示，且不暴露该邮箱是否存在**。`
  `- **U1**: The **密码重置链接** shall **是唯一的，并在首次使用或24小时后立即失效**。`
---