/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hbase;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hugegraph.backend.store.BackendMetrics;
import org.apache.hugegraph.backend.store.hbase.HbaseSessions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.UnitUtil;

public class HbaseMetrics
implements BackendMetrics {
    private final HbaseSessions hbase;

    public HbaseMetrics(HbaseSessions hbase) {
        E.checkArgumentNotNull((Object)((Object)hbase), (String)"HBase connection is not opened", (Object[])new Object[0]);
        this.hbase = hbase;
    }

    public Map<String, Object> metrics() {
        Map<String, Object> results = this.clusterInfo();
        if (results.containsKey("exception")) {
            return results;
        }
        try (Admin admin = this.hbase.hbase().getAdmin();){
            ClusterMetrics clusterMetrics = admin.getClusterMetrics();
            Map metrics = clusterMetrics.getLiveServerMetrics();
            Map regionServers = InsertionOrderUtil.newMap();
            for (Map.Entry e : metrics.entrySet()) {
                ServerName server = (ServerName)e.getKey();
                ServerMetrics serverMetrics = (ServerMetrics)e.getValue();
                regionServers.put(server.getAddress().toString(), HbaseMetrics.formatMetrics(serverMetrics));
            }
            results.put("servers", regionServers);
        }
        catch (Throwable e) {
            results.put("exception", e.toString());
        }
        return results;
    }

    public Map<String, Object> compact(List<String> tableNames) {
        Map<String, Object> results = this.clusterInfo();
        if (results.containsKey("exception")) {
            return results;
        }
        try {
            this.hbase.compactTables(tableNames);
            results.put("servers", ImmutableMap.of((Object)"cluster", (Object)"OK"));
        }
        catch (Throwable e) {
            results.put("exception", e.toString());
        }
        return results;
    }

    private Map<String, Object> clusterInfo() {
        Map results = InsertionOrderUtil.newMap();
        try (Admin admin = this.hbase.hbase().getAdmin();){
            ClusterMetrics clusterMetrics = admin.getClusterMetrics();
            results.put("cluster_id", clusterMetrics.getClusterId());
            results.put("master_name", clusterMetrics.getMasterName().getAddress().toString());
            results.put("average_load", clusterMetrics.getAverageLoad());
            results.put("hbase_version", clusterMetrics.getHBaseVersion());
            results.put("region_count", clusterMetrics.getRegionCount());
            results.put("leaving_servers", HbaseMetrics.serversAddress(clusterMetrics.getDeadServerNames()));
            Collection regionServers = admin.getRegionServers();
            results.put("nodes", regionServers.size());
            results.put("region_servers", HbaseMetrics.serversAddress(regionServers));
        }
        catch (Throwable e) {
            results.put("exception", e.toString());
        }
        return results;
    }

    private static Map<String, Object> formatMetrics(ServerMetrics serverMetrics) {
        Map metrics = InsertionOrderUtil.newMap();
        Size memMax = serverMetrics.getMaxHeapSize();
        Size memUsed = serverMetrics.getUsedHeapSize();
        long memUsedBytes = (long)memUsed.get(Size.Unit.BYTE);
        metrics.put("mem_max", memMax.get(Size.Unit.MEGABYTE));
        metrics.put("mem_used", memUsed.get(Size.Unit.MEGABYTE));
        metrics.put("mem_used_readable", UnitUtil.bytesToReadableString((long)memUsedBytes));
        metrics.put("mem_unit", "MB");
        Collection<RegionMetrics> regions = serverMetrics.getRegionMetrics().values();
        long fileSizeBytes = 0L;
        for (RegionMetrics region : regions) {
            Double tempValue = region.getStoreFileSize().get(Size.Unit.BYTE);
            fileSizeBytes += tempValue.longValue();
        }
        metrics.put("disk_usage", UnitUtil.bytesToGB((long)fileSizeBytes));
        metrics.put("disk_usage_readable", UnitUtil.bytesToReadableString((long)fileSizeBytes));
        metrics.put("disk_unit", "GB");
        metrics.put("request_count", serverMetrics.getRequestCount());
        metrics.put("request_count_per_second", serverMetrics.getRequestCountPerSecond());
        metrics.put("coprocessor_names", serverMetrics.getCoprocessorNames());
        metrics.put("regions", HbaseMetrics.formatRegions(regions));
        return metrics;
    }

    private static Map<String, Object> formatRegions(Collection<RegionMetrics> regions) {
        Map metrics = InsertionOrderUtil.newMap();
        for (RegionMetrics region : regions) {
            metrics.put(region.getNameAsString(), HbaseMetrics.formatRegion(region));
        }
        return metrics;
    }

    private static Map<String, Object> formatRegion(RegionMetrics region) {
        Map metrics = InsertionOrderUtil.newMap();
        Size fileSize = region.getStoreFileSize();
        long fileSizeBytes = (long)fileSize.get(Size.Unit.BYTE);
        metrics.put("disk_usage", fileSize.get(Size.Unit.GIGABYTE));
        metrics.put("disk_usage_readable", UnitUtil.bytesToReadableString((long)fileSizeBytes));
        metrics.put("disk_unit", "GB");
        metrics.put("index_store_size", region.getStoreFileIndexSize().get(Size.Unit.MEGABYTE));
        metrics.put("root_level_index_store_size", region.getStoreFileRootLevelIndexSize().get(Size.Unit.MEGABYTE));
        metrics.put("mem_store_size", region.getMemStoreSize().get(Size.Unit.MEGABYTE));
        metrics.put("bloom_filter_size", region.getBloomFilterSize().get(Size.Unit.MEGABYTE));
        metrics.put("size_unit", "MB");
        metrics.put("store_count", region.getStoreCount());
        metrics.put("store_file_count", region.getStoreFileCount());
        metrics.put("request_count", region.getRequestCount());
        metrics.put("write_request_count", region.getWriteRequestCount());
        metrics.put("read_request_count", region.getReadRequestCount());
        metrics.put("filtered_read_request_count", region.getFilteredReadRequestCount());
        metrics.put("completed_sequence_id", region.getCompletedSequenceId());
        metrics.put("data_locality", Float.valueOf(region.getDataLocality()));
        metrics.put("compacted_cell_count", region.getCompactedCellCount());
        metrics.put("compacting_cell_count", region.getCompactingCellCount());
        metrics.put("last_compaction_time", new Date(region.getLastMajorCompactionTimestamp()));
        return metrics;
    }

    private static List<String> serversAddress(Collection<ServerName> servers) {
        return servers.stream().map(server -> server.getAddress().toString()).collect(Collectors.toList());
    }
}

