/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.SingleSourceShortestPathTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/weightedshortestpath")
@Singleton
@Tag(name="WeightedShortestPathAPI")
public class WeightedShortestPathAPI
extends API {
    private static final Logger LOG = Log.logger(WeightedShortestPathAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="weight") String weight, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="skip_degree") @DefaultValue(value="0") long skipDegree, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity, @QueryParam(value="with_vertex") boolean withVertex) {
        LOG.debug("Graph [{}] get weighted shortest path between '{}' and '{}' with direction {}, edge label {}, weight property {}, max degree '{}', skip degree '{}', capacity '{}', and with vertex '{}'", new Object[]{graph, source, target, direction, edgeLabel, weight, maxDegree, skipDegree, capacity, withVertex});
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        E.checkArgumentNotNull((Object)weight, (String)"The weight property can't be null", (Object[])new Object[0]);
        HugeGraph g = WeightedShortestPathAPI.graph(manager, graph);
        SingleSourceShortestPathTraverser traverser = new SingleSourceShortestPathTraverser(g);
        SingleSourceShortestPathTraverser.NodeWithWeight path = traverser.weightedShortestPath(sourceId, targetId, dir, edgeLabel, weight, maxDegree, skipDegree, capacity);
        Iterator iterator = QueryResults.emptyIterator();
        if (path != null && withVertex) {
            assert (!path.node().path().isEmpty());
            iterator = g.vertices(path.node().path().toArray());
        }
        return manager.serializer((Graph)g).writeWeightedPath(path, iterator);
    }
}

