/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.profile;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.version.CoreVersion;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;
import org.glassfish.jersey.model.Parameter;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.model.ResourceMethod;

@Path(value="/")
@Singleton
@Tag(name="ProfileAPI")
public class ProfileAPI {
    private static final String SERVICE = "hugegraph";
    private static final String DOC = "https://hugegraph.github.io/hugegraph-doc/";
    private static final String API_DOC = "https://hugegraph.github.io/hugegraph-doc/clients/hugegraph-api.html";
    private static String SERVER_PROFILES = null;
    private static String API_PROFILES = null;

    @GET
    @Timed
    @Produces(value={"application/json"})
    public String getProfile(@Context Application application) {
        if (SERVER_PROFILES != null) {
            return SERVER_PROFILES;
        }
        Map profiles = InsertionOrderUtil.newMap();
        profiles.put("service", SERVICE);
        profiles.put("version", CoreVersion.VERSION.toString());
        profiles.put("doc", DOC);
        profiles.put("api_doc", API_DOC);
        TreeSet<String> apis = new TreeSet<String>();
        for (Class clazz : application.getClasses()) {
            if (!ProfileAPI.isAnnotatedPathClass(clazz)) continue;
            Resource resource = Resource.from((Class)clazz);
            APICategory apiCategory = APICategory.parse(resource.getName());
            apis.add(apiCategory.dir);
        }
        profiles.put("apis", apis);
        SERVER_PROFILES = JsonUtil.toJson((Object)profiles);
        return SERVER_PROFILES;
    }

    @GET
    @Path(value="apis")
    @Timed
    @Produces(value={"application/json"})
    public String showAllAPIs(@Context Application application) {
        if (API_PROFILES != null) {
            return API_PROFILES;
        }
        APIProfiles apiProfiles = new APIProfiles();
        for (Class clazz : application.getClasses()) {
            if (!ProfileAPI.isAnnotatedPathClass(clazz)) continue;
            Resource resource = Resource.from((Class)clazz);
            APICategory apiCategory = APICategory.parse(resource.getName());
            String url = resource.getPath();
            for (ResourceMethod rm : resource.getResourceMethods()) {
                APIProfile profile = APIProfile.parse(url, rm);
                apiProfiles.put(apiCategory, profile);
            }
            for (Resource childResource : resource.getChildResources()) {
                String childUrl = url + "/" + childResource.getPath();
                for (ResourceMethod rm : childResource.getResourceMethods()) {
                    APIProfile profile = APIProfile.parse(childUrl, rm);
                    apiProfiles.put(apiCategory, profile);
                }
            }
        }
        API_PROFILES = JsonUtil.toJson((Object)apiProfiles);
        return API_PROFILES;
    }

    private static boolean isAnnotatedPathClass(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Path.class)) {
            return true;
        }
        for (Class<?> i : clazz.getInterfaces()) {
            if (!i.isAnnotationPresent(Path.class)) continue;
            return true;
        }
        return false;
    }

    private static class APICategory {
        private final String dir;
        private final String category;

        public APICategory(String dir, String category) {
            this.dir = dir;
            this.category = category;
        }

        public static APICategory parse(String fullName) {
            String[] parts = StringUtils.split((String)fullName, (String)".");
            E.checkState((parts.length >= 2 ? 1 : 0) != 0, (String)"Invalid api name", (Object[])new Object[0]);
            String dir = parts[parts.length - 2];
            String category = parts[parts.length - 1];
            return new APICategory(dir, category);
        }
    }

    private static class APIProfile {
        @JsonProperty(value="url")
        private final String url;
        @JsonProperty(value="method")
        private final String method;
        @JsonProperty(value="parameters")
        private final List<ParamInfo> parameters;

        public APIProfile(String url, String method, List<ParamInfo> parameters) {
            this.url = url;
            this.method = method;
            this.parameters = parameters;
        }

        public static APIProfile parse(String url, ResourceMethod resource) {
            String method = resource.getHttpMethod();
            ArrayList<ParamInfo> params = new ArrayList<ParamInfo>();
            for (Parameter param : resource.getInvocable().getParameters()) {
                if (param.getSource() == Parameter.Source.QUERY) {
                    String name = param.getSourceName();
                    String type = param.getType().getTypeName();
                    String defaultValue = param.getDefaultValue();
                    params.add(new ParamInfo(name, type, defaultValue));
                    continue;
                }
                if (param.getSource() != Parameter.Source.ENTITY) continue;
                String type = param.getType().getTypeName();
                params.add(new ParamInfo("body", type));
            }
            return new APIProfile(url, method, params);
        }

        private static class ParamInfo {
            @JsonProperty(value="name")
            private final String name;
            @JsonProperty(value="type")
            private final String type;
            @JsonProperty(value="default_value")
            private final String defaultValue;

            public ParamInfo(String name, String type) {
                this(name, type, null);
            }

            public ParamInfo(String name, String type, String defaultValue) {
                this.name = name;
                this.type = type;
                this.defaultValue = defaultValue;
            }
        }
    }

    private static class APIProfiles {
        @JsonProperty(value="apis")
        private final Map<String, Map<String, List<APIProfile>>> apis = new TreeMap<String, Map<String, List<APIProfile>>>();

        public void put(APICategory category, APIProfile profile) {
            Map categories = this.apis.computeIfAbsent(category.dir, k -> new TreeMap());
            List profiles = categories.computeIfAbsent(category.category, k -> new ArrayList());
            profiles.add(profile);
        }
    }
}

