/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hugegraph.util.RateLimiter;

public class FixedTimerWindowRateLimiter
implements RateLimiter {
    private final Timer timer = new Timer("RateAuditLog", true);
    private final LongAdder count = new LongAdder();
    private final int limit;

    public FixedTimerWindowRateLimiter(int limitPerSecond) {
        this.limit = limitPerSecond;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (FixedTimerWindowRateLimiter.this.count.intValue() >= FixedTimerWindowRateLimiter.this.limit) {
                    FixedTimerWindowRateLimiter.this.count.reset();
                }
            }
        }, 0L, 1000L);
    }

    @Override
    public boolean tryAcquire() {
        if (this.count.intValue() >= this.limit) {
            return false;
        }
        this.count.increment();
        return true;
    }
}

