/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.Userdata;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.type.Typeable;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;

public abstract class SchemaElement
implements Nameable,
Typeable,
Cloneable {
    public static final int MAX_PRIMITIVE_SYS_ID = 32;
    public static final int NEXT_PRIMITIVE_SYS_ID = 8;
    protected static final int VL_IL_ID = -1;
    protected static final int EL_IL_ID = -2;
    protected static final int PKN_IL_ID = -3;
    protected static final int VLN_IL_ID = -4;
    protected static final int ELN_IL_ID = -5;
    protected static final int ILN_IL_ID = -6;
    protected static final int OLAP_VL_ID = -7;
    public static final Id NONE_ID = IdGenerator.ZERO;
    public static final String UNDEF = "~undefined";
    protected final HugeGraph graph;
    private final Id id;
    private final String name;
    private final Userdata userdata;
    private SchemaStatus status;

    public SchemaElement(HugeGraph graph, Id id, String name) {
        E.checkArgumentNotNull((Object)id, (String)"SchemaElement id can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)name, (String)"SchemaElement name can't be null", (Object[])new Object[0]);
        this.graph = graph;
        this.id = id;
        this.name = name;
        this.userdata = new Userdata();
        this.status = SchemaStatus.CREATED;
    }

    public HugeGraph graph() {
        E.checkState((this.graph != null ? 1 : 0) != 0, (String)"Graph is null of schema '%s'", (Object[])new Object[]{this.name});
        return this.graph;
    }

    public Id id() {
        return this.id;
    }

    public long longId() {
        return this.id.asLong();
    }

    @Override
    public String name() {
        return this.name;
    }

    public Map<String, Object> userdata() {
        return Collections.unmodifiableMap(this.userdata);
    }

    public void userdata(String key, Object value) {
        E.checkArgumentNotNull((Object)key, (String)"userdata key", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)value, (String)"userdata value", (Object[])new Object[0]);
        this.userdata.put(key, value);
    }

    public void userdata(Userdata userdata) {
        this.userdata.putAll(userdata);
    }

    public void removeUserdata(String key) {
        E.checkArgumentNotNull((Object)key, (String)"The userdata key can't be null", (Object[])new Object[0]);
        this.userdata.remove(key);
    }

    public void removeUserdata(Userdata userdata) {
        for (String key : userdata.keySet()) {
            this.userdata.remove(key);
        }
    }

    public SchemaStatus status() {
        return this.status;
    }

    public void status(SchemaStatus status) {
        this.status = status;
    }

    public boolean system() {
        return this.longId() < 0L;
    }

    public boolean primitive() {
        long id = this.longId();
        return -32L <= id && id < 0L;
    }

    public boolean hidden() {
        return Graph.Hidden.isHidden((String)this.name());
    }

    public SchemaElement copy() {
        try {
            return (SchemaElement)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HugeException("Failed to clone schema", e);
        }
    }

    public boolean hasSameContent(SchemaElement other) {
        return Objects.equal((Object)this.name(), (Object)other.name()) && Objects.equal(this.userdata(), other.userdata());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SchemaElement)) {
            return false;
        }
        SchemaElement other = (SchemaElement)obj;
        return this.type() == other.type() && this.id.equals(other.id());
    }

    public int hashCode() {
        return this.type().hashCode() ^ this.id.hashCode();
    }

    public String toString() {
        return String.format("%s(id=%s)", this.name, this.id);
    }

    public static int schemaId(Id id) {
        long l = id.asLong();
        E.checkArgument((Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Schema id is out of bound: %s", (Object[])new Object[]{l});
        return (int)l;
    }

    public static class TaskWithSchema {
        private SchemaElement schemaElement;
        private Id task;

        public TaskWithSchema(SchemaElement schemaElement, Id task) {
            E.checkNotNull((Object)schemaElement, (String)"schema element");
            this.schemaElement = schemaElement;
            this.task = task;
        }

        public void propertyKey(PropertyKey propertyKey) {
            E.checkNotNull((Object)propertyKey, (String)"property key");
            this.schemaElement = propertyKey;
        }

        public void indexLabel(IndexLabel indexLabel) {
            E.checkNotNull((Object)indexLabel, (String)"index label");
            this.schemaElement = indexLabel;
        }

        public PropertyKey propertyKey() {
            E.checkState((boolean)(this.schemaElement instanceof PropertyKey), (String)"Expect property key, but actual schema type is '%s'", (Object[])new Object[]{this.schemaElement.getClass()});
            return (PropertyKey)this.schemaElement;
        }

        public IndexLabel indexLabel() {
            E.checkState((boolean)(this.schemaElement instanceof IndexLabel), (String)"Expect index label, but actual schema type is '%s'", (Object[])new Object[]{this.schemaElement.getClass()});
            return (IndexLabel)this.schemaElement;
        }

        public SchemaElement schemaElement() {
            return this.schemaElement;
        }

        public Id task() {
            return this.task;
        }
    }
}

