/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.comm;

import com.google.common.collect.ImmutableMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.comm.AbstractCommAlgorithm;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;

public class TriangleCountAlgorithm
extends AbstractCommAlgorithm {
    public static final String ALGO_NAME = "triangle_count";

    @Override
    public String name() {
        return ALGO_NAME;
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        TriangleCountAlgorithm.direction4Out(parameters);
        TriangleCountAlgorithm.degree(parameters);
        TriangleCountAlgorithm.workersWhenBoth(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        int workers = TriangleCountAlgorithm.workersWhenBoth(parameters);
        try (Traverser traverser = new Traverser(job, workers);){
            Object object = traverser.triangleCount(TriangleCountAlgorithm.direction4Out(parameters), TriangleCountAlgorithm.degree(parameters));
            return object;
        }
    }

    protected static int workersWhenBoth(Map<String, Object> parameters) {
        Directions direction = TriangleCountAlgorithm.direction4Out(parameters);
        int workers = TriangleCountAlgorithm.workers(parameters);
        E.checkArgument((direction == Directions.BOTH || workers <= 0 ? 1 : 0) != 0, (String)"The workers must be not set when direction!=BOTH, but got workers=%s and direction=%s", (Object[])new Object[]{workers, direction});
        return workers;
    }

    protected static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        protected static final String KEY_TRIANGLES = "triangles";
        protected static final String KEY_TRIADS = "triads";

        public Traverser(UserJob<Object> job, int workers) {
            super(job, TriangleCountAlgorithm.ALGO_NAME, workers);
        }

        protected Traverser(UserJob<Object> job, String name, int workers) {
            super(job, name, workers);
        }

        public Object triangleCount(Directions direction, long degree) {
            Map results = this.triangles(direction, degree);
            results = InsertionOrderUtil.newMap(results);
            results.remove(KEY_TRIADS);
            return results;
        }

        protected Map<String, Long> triangles(Directions direction, long degree) {
            if (direction == null || direction == Directions.BOTH) {
                return this.trianglesForBothDir(degree);
            }
            assert (direction == Directions.OUT || direction == Directions.IN);
            Iterator<Edge> edges = this.edges(direction);
            long triangles = 0L;
            long triads = 0L;
            long totalEdges = 0L;
            long totalVertices = 0L;
            Id vertex = null;
            Set<Id> adjVertices = Traverser.newOrderedSet();
            while (edges.hasNext()) {
                HugeEdge edge = (HugeEdge)edges.next();
                this.updateProgress(++totalEdges);
                Id source = edge.ownerVertex().id();
                Id target = edge.otherVertex().id();
                if (vertex == source) {
                    if ((long)adjVertices.size() >= degree && degree != -1L) continue;
                    adjVertices.add(target);
                    continue;
                }
                if (vertex != null) {
                    assert (vertex != source);
                    triangles += this.intersect(degree, adjVertices);
                    triads += this.localTriads(adjVertices.size());
                    ++totalVertices;
                    adjVertices = Traverser.newOrderedSet();
                }
                vertex = source;
                adjVertices.add(target);
            }
            if (vertex != null) {
                triangles += this.intersect(degree, adjVertices);
                triads += this.localTriads(adjVertices.size());
                ++totalVertices;
            }
            String suffix = "_" + direction.string();
            return ImmutableMap.of((Object)("edges" + suffix), (Object)totalEdges, (Object)("vertices" + suffix), (Object)totalVertices, (Object)KEY_TRIANGLES, (Object)triangles, (Object)KEY_TRIADS, (Object)triads);
        }

        protected Map<String, Long> trianglesForBothDir(long degree) {
            AtomicLong triangles = new AtomicLong(0L);
            AtomicLong triads = new AtomicLong(0L);
            AtomicLong totalEdges = new AtomicLong(0L);
            AtomicLong totalVertices = new AtomicLong(0L);
            this.traverse(null, null, v -> {
                Id source = (Id)v.id();
                MutableLong edgesCount = new MutableLong(0L);
                Set<Id> adjVertices = this.adjacentVertices(source, degree, edgesCount);
                triangles.addAndGet(this.intersect(degree, adjVertices));
                triads.addAndGet(this.localTriads(adjVertices.size()));
                totalVertices.incrementAndGet();
                totalEdges.addAndGet(edgesCount.longValue());
            });
            assert (totalEdges.get() % 2L == 0L);
            assert (triangles.get() % 3L == 0L);
            totalEdges.getAndAccumulate(2L, (l, w) -> l / w);
            triangles.getAndAccumulate(3L, (l, w) -> l / w);
            triads.addAndGet(triangles.get() * -2L);
            return ImmutableMap.of((Object)"edges", (Object)totalEdges.get(), (Object)"vertices", (Object)totalVertices.get(), (Object)KEY_TRIANGLES, (Object)triangles.get(), (Object)KEY_TRIADS, (Object)triads.get());
        }

        private Set<Id> adjacentVertices(Id source, long degree, MutableLong edgesCount) {
            Iterator<Id> adjVertices = this.adjacentVertices(source, Directions.BOTH, null, degree);
            Set<Id> set = Traverser.newOrderedSet();
            while (adjVertices.hasNext()) {
                edgesCount.increment();
                set.add(adjVertices.next());
            }
            return set;
        }

        protected long intersect(long degree, Set<Id> adjVertices) {
            long count = 0L;
            Directions dir = Directions.OUT;
            Id empty = IdGenerator.ZERO;
            for (Id v : adjVertices) {
                Iterator<Id> vertices = this.adjacentVertices(v, dir, null, degree);
                Id lastVertex = empty;
                while (vertices.hasNext()) {
                    Id vertex = vertices.next();
                    if (lastVertex.equals(vertex)) continue;
                    lastVertex = vertex;
                    if (!adjVertices.contains(vertex)) continue;
                    ++count;
                }
            }
            return count;
        }

        protected long localTriads(int size) {
            return (long)size * ((long)size - 1L) / 2L;
        }

        protected static <V> Set<V> newOrderedSet() {
            return new TreeSet();
        }
    }
}

