/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.message.http;

import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.exception.SofaTimeOutException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.message.AbstractResponseFuture;
import com.alipay.sofa.rpc.message.ResponseFuture;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HttpResponseFuture<V>
extends AbstractResponseFuture<V> {
    protected final SofaRequest request;
    protected SofaResponse response;

    public HttpResponseFuture(SofaRequest request, int timeout) {
        super(timeout);
        this.request = request;
    }

    @Override
    protected TimeoutException clientTimeoutException() {
        throw new SofaTimeOutException(LogCodes.getLog("020100005", SerializerFactory.getAliasByCode(this.request.getSerializeType()), this.request.getTargetServiceUniqueName(), this.request.getMethodName(), "", StringUtils.objectsToString(this.request.getMethodArgs()), this.timeout));
    }

    @Override
    protected V getNow() throws ExecutionException {
        if (this.cause != null) {
            throw new ExecutionException(this.cause);
        }
        if (this.result instanceof SofaResponse) {
            SofaResponse response = (SofaResponse)this.result;
            if (response.isError()) {
                this.cause = new SofaRpcException(199, response.getErrorMsg());
                throw new ExecutionException(this.cause);
            }
            this.result = response.getAppResponse();
            if (this.result instanceof Throwable) {
                throw new ExecutionException((Throwable)this.result);
            }
            return (V)this.result;
        }
        return (V)this.result;
    }

    @Override
    protected void releaseIfNeed(Object result) {
        AbstractByteBuf byteBuffer;
        if (result instanceof SofaResponse && (byteBuffer = this.response.getData()) != null) {
            byteBuffer.release();
            this.response.setData(null);
        }
    }

    @Override
    public ResponseFuture addListeners(List<SofaResponseCallback> list) {
        throw new UnsupportedOperationException("Not supported, Please use callback function");
    }

    @Override
    public ResponseFuture addListener(SofaResponseCallback sofaResponseCallback) {
        throw new UnsupportedOperationException("Not supported, Please use callback function");
    }

    @Override
    public void notifyListeners() {
    }

    public SofaResponse getSofaResponse(int timeout, TimeUnit unit) throws CancellationException, TimeoutException, InterruptedException, ExecutionException {
        long realTimeOut = unit.toMillis(timeout);
        long remainTime = realTimeOut - (this.sentTime - this.genTime);
        if (remainTime <= 0L ? this.isDone() : this.await(remainTime, TimeUnit.MILLISECONDS)) {
            return this.getNowResponse();
        }
        this.setDoneTime();
        throw new TimeoutException();
    }

    protected SofaResponse getNowResponse() throws ExecutionException, CancellationException {
        if (this.cause != null) {
            if (this.cause == CANCELLATION_CAUSE) {
                throw (CancellationException)this.cause;
            }
            throw new ExecutionException(this.cause);
        }
        if (this.result instanceof SofaResponse) {
            return (SofaResponse)this.result;
        }
        throw new ExecutionException(new IllegalArgumentException("Not sofa response!"));
    }
}

