/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker;

import java.util.Iterator;
import java.util.function.BiFunction;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;

public interface ComputationContext {
    public void sendMessage(Id var1, Value var2);

    default public void sendMessageToAllEdges(Vertex vertex, Value value) {
        for (Edge edge : vertex.edges()) {
            this.sendMessage(edge.targetId(), value);
        }
    }

    default public <M extends Value> void sendMessageToAllEdgesIf(Vertex vertex, M value, BiFunction<M, Id, Boolean> filter) {
        for (Edge edge : vertex.edges()) {
            if (!filter.apply(value, edge.targetId()).booleanValue()) continue;
            this.sendMessage(edge.targetId(), value);
        }
    }

    default public <M extends Value> void sendMessagesToAllEdges(Vertex vertex, Iterator<M> values) {
        while (values.hasNext()) {
            Value value = (Value)values.next();
            this.sendMessageToAllEdges(vertex, value);
        }
    }

    default public <M extends Value> void sendMessagesToAllEdgesIf(Vertex vertex, Iterator<M> values, BiFunction<M, Id, Boolean> filter) {
        while (values.hasNext()) {
            Value value = (Value)values.next();
            for (Edge edge : vertex.edges()) {
                if (!filter.apply(value, edge.targetId()).booleanValue()) continue;
                this.sendMessage(edge.targetId(), value);
            }
        }
    }

    public long totalVertexCount();

    public long totalEdgeCount();

    public int superstep();

    public <V extends Value> Combiner<V> combiner();
}

