/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.worker;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.computer.core.aggregator.Aggregator;
import org.apache.hugegraph.computer.core.aggregator.WorkerAggrManager;
import org.apache.hugegraph.computer.core.bsp.Bsp4Worker;
import org.apache.hugegraph.computer.core.combiner.Combiner;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.ContainerInfo;
import org.apache.hugegraph.computer.core.compute.ComputeManager;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.SuperstepStat;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.input.WorkerInputManager;
import org.apache.hugegraph.computer.core.manager.Managers;
import org.apache.hugegraph.computer.core.network.DataClientManager;
import org.apache.hugegraph.computer.core.network.DataServerManager;
import org.apache.hugegraph.computer.core.network.connection.TransportConnectionManager;
import org.apache.hugegraph.computer.core.receiver.MessageRecvManager;
import org.apache.hugegraph.computer.core.rpc.WorkerRpcManager;
import org.apache.hugegraph.computer.core.sender.MessageSendManager;
import org.apache.hugegraph.computer.core.sort.sorting.RecvSortManager;
import org.apache.hugegraph.computer.core.sort.sorting.SendSortManager;
import org.apache.hugegraph.computer.core.store.FileManager;
import org.apache.hugegraph.computer.core.util.ShutdownHook;
import org.apache.hugegraph.computer.core.worker.Computation;
import org.apache.hugegraph.computer.core.worker.WorkerContext;
import org.apache.hugegraph.computer.core.worker.WorkerStat;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class WorkerService
implements Closeable {
    private static final Logger LOG = Log.logger(WorkerService.class);
    private final ComputerContext context = ComputerContext.instance();
    private final Managers managers = new Managers();
    private final Map<Integer, ContainerInfo> workers = new HashMap<Integer, ContainerInfo>();
    private volatile boolean inited = false;
    private volatile boolean closed = false;
    private Config config;
    private Bsp4Worker bsp4Worker;
    private ComputeManager computeManager;
    private ContainerInfo workerInfo;
    private Combiner<Value> combiner;
    private ContainerInfo masterInfo;
    private volatile ShutdownHook shutdownHook = new ShutdownHook();
    private volatile Thread serviceThread;

    public void init(Config config) {
        E.checkArgument((!this.inited ? 1 : 0) != 0, (String)"The %s has been initialized", (Object[])new Object[]{this});
        this.serviceThread = Thread.currentThread();
        this.registerShutdownHook();
        this.config = config;
        this.workerInfo = new ContainerInfo();
        LOG.info("{} Start to initialize worker", (Object)this);
        this.bsp4Worker = new Bsp4Worker(this.config, this.workerInfo);
        this.masterInfo = this.bsp4Worker.waitMasterInitDone();
        InetSocketAddress address = this.initManagers(this.masterInfo);
        this.workerInfo.updateAddress(address);
        Computation computation = (Computation)this.config.createObject(ComputerOptions.WORKER_COMPUTATION_CLASS);
        LOG.info("Loading computation '{}' in category '{}'", (Object)computation.name(), (Object)computation.category());
        this.combiner = (Combiner)this.config.createObject(ComputerOptions.WORKER_COMBINER_CLASS, false);
        if (this.combiner == null) {
            LOG.info("None combiner is provided for computation '{}'", (Object)computation.name());
        } else {
            LOG.info("Combiner '{}' is provided for computation '{}'", (Object)this.combiner.name(), (Object)computation.name());
        }
        LOG.info("{} register WorkerService", (Object)this);
        this.bsp4Worker.workerInitDone();
        List<ContainerInfo> workers = this.bsp4Worker.waitMasterAllInitDone();
        DataClientManager dm = (DataClientManager)this.managers.get("data_client");
        for (ContainerInfo worker : workers) {
            this.workers.put(worker.id(), worker);
            dm.connect(worker.id(), worker.hostname(), worker.dataPort());
        }
        this.computeManager = new ComputeManager(this.context, this.managers);
        this.managers.initedAll(this.config);
        LOG.info("{} WorkerService initialized", (Object)this);
        this.inited = true;
    }

    private void registerShutdownHook() {
        this.shutdownHook.hook(() -> {
            this.stopServiceThread();
            this.cleanAndCloseBsp();
        });
    }

    @Override
    public synchronized void close() {
        this.checkInited();
        if (this.closed) {
            LOG.info("{} WorkerService had closed before", (Object)this);
            return;
        }
        this.computeManager.close();
        this.managers.closeAll(this.config);
        this.bsp4Worker.workerCloseDone();
        this.bsp4Worker.close();
        this.shutdownHook.unhook();
        this.closed = true;
        LOG.info("{} WorkerService closed", (Object)this);
    }

    private void stopServiceThread() {
        if (this.serviceThread == null) {
            return;
        }
        try {
            this.serviceThread.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanAndCloseBsp() {
        if (this.bsp4Worker == null) {
            return;
        }
        this.bsp4Worker.clean();
        this.bsp4Worker.close();
    }

    public void execute() {
        SuperstepStat superstepStat;
        this.checkInited();
        LOG.info("{} WorkerService execute", (Object)this);
        int superstep = this.bsp4Worker.waitMasterResumeDone();
        if (superstep == -1) {
            superstepStat = this.inputstep();
            ++superstep;
        } else {
            superstepStat = null;
        }
        while (superstepStat.active()) {
            SuperstepContext context = new SuperstepContext(superstep, superstepStat);
            LOG.info("Start computation of superstep {}", (Object)superstep);
            if (superstep > 0) {
                this.computeManager.takeRecvedMessages();
            }
            this.managers.beforeSuperstep(this.config, superstep);
            this.bsp4Worker.workerStepPrepareDone(superstep);
            this.bsp4Worker.waitMasterStepPrepareDone(superstep);
            WorkerStat workerStat = this.computeManager.compute(context, superstep);
            this.bsp4Worker.workerStepComputeDone(superstep);
            this.bsp4Worker.waitMasterStepComputeDone(superstep);
            this.managers.afterSuperstep(this.config, superstep);
            this.bsp4Worker.workerStepDone(superstep, workerStat);
            LOG.info("End computation of superstep {}", (Object)superstep);
            superstepStat = this.bsp4Worker.waitMasterStepDone(superstep);
            ++superstep;
        }
        this.outputstep();
    }

    public String toString() {
        Object id = this.workerInfo == null ? "?" + this.hashCode() : Integer.valueOf(this.workerInfo.id());
        return String.format("[worker %s]", id);
    }

    private InetSocketAddress initManagers(ContainerInfo masterInfo) {
        WorkerRpcManager rpcManager = new WorkerRpcManager();
        this.managers.add(rpcManager);
        WorkerRpcManager.updateRpcRemoteServerConfig(this.config, masterInfo.hostname(), masterInfo.rpcPort());
        rpcManager.init(this.config);
        WorkerAggrManager aggregatorManager = new WorkerAggrManager(this.context);
        aggregatorManager.service(rpcManager.aggregateRpcService());
        this.managers.add(aggregatorManager);
        FileManager fileManager = new FileManager();
        this.managers.add(fileManager);
        RecvSortManager recvSortManager = new RecvSortManager(this.context);
        this.managers.add(recvSortManager);
        MessageRecvManager recvManager = new MessageRecvManager(this.context, fileManager, recvSortManager);
        this.managers.add(recvManager);
        TransportConnectionManager connManager = new TransportConnectionManager();
        DataServerManager serverManager = new DataServerManager(connManager, recvManager);
        this.managers.add(serverManager);
        DataClientManager clientManager = new DataClientManager(connManager, this.context);
        this.managers.add(clientManager);
        SendSortManager sendSortManager = new SendSortManager(this.context);
        this.managers.add(sendSortManager);
        MessageSendManager sendManager = new MessageSendManager(this.context, sendSortManager, clientManager.sender());
        this.managers.add(sendManager);
        WorkerInputManager inputManager = new WorkerInputManager(this.context, sendManager);
        inputManager.service(rpcManager.inputSplitService());
        this.managers.add(inputManager);
        this.managers.initAll(this.config);
        InetSocketAddress address = serverManager.address();
        LOG.info("{} WorkerService initialized managers with data server address '{}'", (Object)this, (Object)address);
        return address;
    }

    private void checkInited() {
        E.checkArgument((boolean)this.inited, (String)"The %s has not been initialized", (Object[])new Object[]{this});
    }

    private SuperstepStat inputstep() {
        LOG.info("{} WorkerService inputstep started", (Object)this);
        WorkerInputManager manager = (WorkerInputManager)this.managers.get("worker_input");
        manager.loadGraph();
        this.bsp4Worker.workerInputDone();
        this.bsp4Worker.waitMasterInputDone();
        WorkerStat workerStat = this.computeManager.input();
        this.bsp4Worker.workerStepDone(-1, workerStat);
        SuperstepStat superstepStat = this.bsp4Worker.waitMasterStepDone(-1);
        manager.close(this.config);
        LOG.info("{} WorkerService inputstep finished", (Object)this);
        return superstepStat;
    }

    private void outputstep() {
        this.computeManager.output();
        this.bsp4Worker.workerOutputDone();
        LOG.info("{} WorkerService outputstep finished", (Object)this);
    }

    private class SuperstepContext
    implements WorkerContext {
        private final int superstep;
        private final SuperstepStat superstepStat;
        private final WorkerAggrManager aggrManager;
        private final MessageSendManager sendManager;

        private SuperstepContext(int superstep, SuperstepStat superstepStat) {
            this.superstep = superstep;
            this.superstepStat = superstepStat;
            this.aggrManager = (WorkerAggrManager)WorkerService.this.managers.get("worker_aggr");
            this.sendManager = (MessageSendManager)WorkerService.this.managers.get("message_send");
        }

        public Config config() {
            return WorkerService.this.config;
        }

        public <V extends Value> Aggregator<V> createAggregator(String name) {
            return this.aggrManager.createAggregator(name);
        }

        public <V extends Value> void aggregateValue(String name, V value) {
            this.aggrManager.aggregateValue(name, value);
        }

        public <V extends Value> V aggregatedValue(String name) {
            return this.aggrManager.aggregatedValue(name);
        }

        public void sendMessage(Id target, Value value) {
            this.sendManager.sendMessage(target, value);
        }

        public void sendMessageToAllEdges(Vertex vertex, Value value) {
            for (Edge edge : vertex.edges()) {
                this.sendMessage(edge.targetId(), value);
            }
        }

        public long totalVertexCount() {
            return this.superstepStat.vertexCount();
        }

        public long totalEdgeCount() {
            return this.superstepStat.edgeCount();
        }

        public int superstep() {
            return this.superstep;
        }

        public <V extends Value> Combiner<V> combiner() {
            return WorkerService.this.combiner;
        }
    }
}

