/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hugegraph.computer.core.sender.QueuedMessage;
import org.apache.hugegraph.util.E;

class MessageQueue {
    private final BlockingQueue<QueuedMessage> queue;
    private final Runnable notEmptyNotifier;

    public MessageQueue(Runnable notEmptyNotifier) {
        E.checkArgumentNotNull((Object)notEmptyNotifier, (String)"The callback to notify that a queue is not empty can't be null", (Object[])new Object[0]);
        this.queue = new LinkedBlockingQueue<QueuedMessage>(128);
        this.notEmptyNotifier = notEmptyNotifier;
    }

    public void put(QueuedMessage message) throws InterruptedException {
        this.queue.put(message);
        this.notEmptyNotifier.run();
    }

    public QueuedMessage peek() {
        return (QueuedMessage)this.queue.peek();
    }

    public QueuedMessage take() throws InterruptedException {
        return this.queue.take();
    }
}

