/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.hg;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.InputSplitFetcher;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.HugeClientBuilder;
import org.apache.hugegraph.structure.graph.Shard;
import org.apache.hugegraph.util.E;

public class HugeInputSplitFetcher
implements InputSplitFetcher {
    private final Config config;
    private final HugeClient client;

    public HugeInputSplitFetcher(Config config) {
        this.config = config;
        String url = (String)config.get((TypedOption)ComputerOptions.HUGEGRAPH_URL);
        String graph = (String)config.get((TypedOption)ComputerOptions.HUGEGRAPH_GRAPH_NAME);
        int timeout = (Integer)config.get((TypedOption)ComputerOptions.INPUT_SPLIT_FETCH_TIMEOUT);
        this.client = new HugeClientBuilder(url, graph).configTimeout(timeout).build();
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public List<InputSplit> fetchVertexInputSplits() {
        long splitSize = (Long)this.config.get((TypedOption)ComputerOptions.INPUT_SPLITS_SIZE);
        int maxSplits = (Integer)this.config.get((TypedOption)ComputerOptions.INPUT_MAX_SPLITS);
        List shards = this.client.traverser().vertexShards(splitSize);
        E.checkArgument((shards.size() <= maxSplits ? 1 : 0) != 0, (String)"Too many shards due to too small splitSize", (Object[])new Object[0]);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (Shard shard : shards) {
            InputSplit split = new InputSplit(shard.start(), shard.end());
            splits.add(split);
        }
        return splits;
    }

    @Override
    public List<InputSplit> fetchEdgeInputSplits() {
        long splitSize = (Long)this.config.get((TypedOption)ComputerOptions.INPUT_SPLITS_SIZE);
        int maxSplits = (Integer)this.config.get((TypedOption)ComputerOptions.INPUT_MAX_SPLITS);
        List shards = this.client.traverser().edgeShards(splitSize);
        E.checkArgument((shards.size() <= maxSplits ? 1 : 0) != 0, (String)"Too many shards due to too small splitSize", (Object[])new Object[0]);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (Shard shard : shards) {
            InputSplit split = new InputSplit(shard.start(), shard.end());
            splits.add(split);
        }
        return splits;
    }
}

