/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.cloud.hadoop.util.ITraceOperation;
import com.google.cloud.hadoop.util.ThreadTrace;
import com.google.common.base.Preconditions;
import com.google.common.flogger.GoogleLogger;
import java.util.ArrayDeque;
import java.util.Deque;

public class TraceOperation
implements ITraceOperation {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    static final ITraceOperation NOOP = new ITraceOperation(){

        @Override
        public void close() {
        }

        @Override
        public ThreadTrace getTrace() {
            return null;
        }

        @Override
        public void annotate(String resultSize, int size) {
        }
    };
    private static ThreadLocal<Deque<ThreadTrace>> traceStack = new ThreadLocal<Deque<ThreadTrace>>(){

        @Override
        protected Deque<ThreadTrace> initialValue() {
            return new ArrayDeque<ThreadTrace>(1);
        }
    };
    private final boolean isRoot;
    private final boolean shouldLog;
    private final String name;
    private final ThreadTrace trace;
    private final ThreadTrace.ThreadTraceEvent startEvent;

    public static ITraceOperation createRootWithLogging(String name, Object context) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        long randomMs = System.currentTimeMillis() % 1000L;
        String trackingId = String.format("%s(%s)_%s", name, context, randomMs);
        return new TraceOperation(name, true, true, new ThreadTrace(trackingId));
    }

    public static ITraceOperation addToExistingTrace(String name) {
        ThreadTrace trace = TraceOperation.current();
        if (trace == null) {
            return NOOP;
        }
        return new TraceOperation(name, false, false, trace);
    }

    public static ThreadTrace current() {
        if (traceStack.get().isEmpty()) {
            return null;
        }
        return traceStack.get().peekLast();
    }

    public static ITraceOperation getChildTrace(ThreadTrace parentTrace, String name) {
        if (parentTrace == null) {
            return NOOP;
        }
        ThreadTrace childTrace = parentTrace.getSubTrace();
        if (childTrace == null) {
            return NOOP;
        }
        return new TraceOperation(name, true, false, childTrace);
    }

    public static String getTrackingId() {
        ThreadTrace threadTrace = TraceOperation.current();
        if (threadTrace == null) {
            return "";
        }
        return threadTrace.getTrackingId();
    }

    private TraceOperation(String name, boolean isRoot, boolean shouldLog, ThreadTrace trace) {
        Preconditions.checkNotNull((Object)trace, (Object)String.format("Trace cannot be null. name=%s;", name));
        this.isRoot = isRoot;
        this.shouldLog = shouldLog;
        this.name = name;
        this.trace = trace;
        if (isRoot) {
            TraceOperation.setupTracingForThread(trace);
        }
        this.startEvent = this.trace.starOperationEvent(name);
    }

    @Override
    public ThreadTrace getTrace() {
        return this.trace;
    }

    @Override
    public void close() {
        if (this.isRoot) {
            TraceOperation.removeTracingForThread();
        }
        this.trace.endOperationEvent(this.startEvent);
        if (this.shouldLog) {
            ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)this.trace);
        }
    }

    @Override
    public void annotate(String resultSize, int size) {
        this.trace.annotate(resultSize, size);
    }

    private static void setupTracingForThread(ThreadTrace trace) {
        traceStack.get().addLast(trace);
    }

    private static void removeTracingForThread() {
        if (traceStack.get().isEmpty()) {
            ((GoogleLogger.Api)logger.atSevere()).log("Did not expect the thread trace to be null");
            return;
        }
        traceStack.get().pollLast();
    }
}

