/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.apache.beam.sdk.io.AutoValue_TextRowCountEstimator;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextSource;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
public abstract class TextRowCountEstimator {
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_NUM_BYTES_PER_FILE = 65536L;
    private static final @UnknownKeyFor @NonNull @Initialized Compression DEFAULT_COMPRESSION = Compression.AUTO;
    private static final  @UnknownKeyFor @NonNull @Initialized FileIO.ReadMatches.DirectoryTreatment DEFAULT_DIRECTORY_TREATMENT = FileIO.ReadMatches.DirectoryTreatment.SKIP;
    private static final @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment DEFAULT_EMPTY_MATCH_TREATMENT = EmptyMatchTreatment.DISALLOW;
    private static final @UnknownKeyFor @NonNull @Initialized SamplingStrategy DEFAULT_SAMPLING_STRATEGY = new SampleAllFiles();

    public abstract @UnknownKeyFor @NonNull @Initialized long getNumSampledBytesPerFile();

    public abstract @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] getDelimiters();

    public abstract @UnknownKeyFor @NonNull @Initialized int getSkipHeaderLines();

    public abstract @UnknownKeyFor @NonNull @Initialized String getFilePattern();

    public abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

    public abstract @UnknownKeyFor @NonNull @Initialized SamplingStrategy getSamplingStrategy();

    public abstract @UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment getEmptyMatchTreatment();

    public abstract  @UnknownKeyFor @NonNull @Initialized FileIO.ReadMatches.DirectoryTreatment getDirectoryTreatment();

    public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_TextRowCountEstimator.Builder().setSamplingStrategy(DEFAULT_SAMPLING_STRATEGY).setNumSampledBytesPerFile(65536L).setCompression(DEFAULT_COMPRESSION).setDirectoryTreatment(DEFAULT_DIRECTORY_TREATMENT).setEmptyMatchTreatment(DEFAULT_EMPTY_MATCH_TREATMENT).setSkipHeaderLines(0);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="https://github.com/spotbugs/spotbugs/issues/756")
    public @UnknownKeyFor @NonNull @Initialized Double estimateRowCount(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized NoEstimationException {
        long linesSize = 0L;
        int numberOfReadLines = 0;
        long totalFileSizes = 0L;
        long totalSampledBytes = 0L;
        int numberOfReadFiles = 0;
        boolean sampledEverything = true;
        MatchResult match = FileSystems.match(this.getFilePattern(), this.getEmptyMatchTreatment());
        for (MatchResult.Metadata metadata : match.metadata()) {
            if (this.getSamplingStrategy().stopSampling(numberOfReadFiles, totalSampledBytes)) {
                sampledEverything = false;
                break;
            }
            if (FileIO.ReadMatches.shouldSkipDirectory(metadata, this.getDirectoryTreatment())) continue;
            FileIO.ReadableFile file = FileIO.ReadMatches.matchToReadableFile(metadata, this.getCompression());
            long readingWindowSize = Math.min(this.getNumSampledBytesPerFile(), metadata.sizeBytes());
            sampledEverything = metadata.sizeBytes() == readingWindowSize && sampledEverything;
            OffsetRange range = new OffsetRange(0L, readingWindowSize);
            TextSource textSource = new TextSource(ValueProvider.StaticValueProvider.of(file.getMetadata().resourceId().toString()), this.getEmptyMatchTreatment(), this.getDelimiters(), this.getSkipHeaderLines());
            CompressedSource<String> source = CompressedSource.from(textSource).withCompression(file.getCompression());
            try (BoundedSource.BoundedReader reader = ((FileBasedSource)source).createForSubrangeOfFile(file.getMetadata(), range.getFrom(), range.getTo()).createReader(pipelineOptions);){
                int numberOfNonEmptyLines = 0;
                boolean more = reader.start();
                while (more) {
                    numberOfNonEmptyLines += ((String)reader.getCurrent()).trim().equals("") ? 0 : 1;
                    more = reader.advance();
                }
                numberOfReadLines += numberOfNonEmptyLines;
                linesSize += numberOfNonEmptyLines == 0 ? 0L : readingWindowSize;
            }
            long fileSize = metadata.sizeBytes();
            numberOfReadFiles += fileSize == 0L ? 0 : 1;
            totalFileSizes += fileSize;
        }
        if (numberOfReadLines == 0 && sampledEverything) {
            return 0.0;
        }
        if (numberOfReadLines == 0) {
            throw new NoEstimationException("Cannot estimate the row count. All the sampled lines are empty");
        }
        return (double)totalFileSizes * (double)numberOfReadLines / (double)linesSize;
    }

    public static class LimitNumberOfTotalBytes
    implements SamplingStrategy {
        @UnknownKeyFor @NonNull @Initialized long limit;

        public LimitNumberOfTotalBytes(@UnknownKeyFor @NonNull @Initialized long limit) {
            this.limit = limit;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean stopSampling(@UnknownKeyFor @NonNull @Initialized int numberOfFiles, @UnknownKeyFor @NonNull @Initialized long totalReadBytes) {
            return totalReadBytes > this.limit;
        }
    }

    public static class LimitNumberOfFiles
    implements SamplingStrategy {
        @UnknownKeyFor @NonNull @Initialized int limit;

        public LimitNumberOfFiles(@UnknownKeyFor @NonNull @Initialized int limit) {
            this.limit = limit;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean stopSampling(@UnknownKeyFor @NonNull @Initialized int numberOfFiles, @UnknownKeyFor @NonNull @Initialized long totalReadBytes) {
            return numberOfFiles > this.limit;
        }
    }

    public static class SampleAllFiles
    implements SamplingStrategy {
        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean stopSampling(@UnknownKeyFor @NonNull @Initialized int numberOfSampledFiles, @UnknownKeyFor @NonNull @Initialized long totalReadBytes) {
            return false;
        }
    }

    public static interface SamplingStrategy {
        public @UnknownKeyFor @NonNull @Initialized boolean stopSampling(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized long var2);
    }

    public static class NoEstimationException
    extends Exception {
        NoEstimationException(@UnknownKeyFor @NonNull @Initialized String message) {
            super(message);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract @UnknownKeyFor @NonNull @Initialized Builder setNumSampledBytesPerFile(@UnknownKeyFor @NonNull @Initialized long var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDirectoryTreatment( @UnknownKeyFor @NonNull @Initialized FileIO.ReadMatches.DirectoryTreatment var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setDelimiters(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSkipHeaderLines(@UnknownKeyFor @NonNull @Initialized int var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setFilePattern(@UnknownKeyFor @NonNull @Initialized String var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setEmptyMatchTreatment(@UnknownKeyFor @NonNull @Initialized EmptyMatchTreatment var1);

        public abstract @UnknownKeyFor @NonNull @Initialized Builder setSamplingStrategy(@UnknownKeyFor @NonNull @Initialized SamplingStrategy var1);

        public abstract @UnknownKeyFor @NonNull @Initialized TextRowCountEstimator build();
    }
}

