/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.jsonoutput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.BaseFileOutputMeta;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutput;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputData;
import org.apache.hop.pipeline.transforms.jsonoutput.JsonOutputField;

@Transform(id="JsonOutput", image="JSO.svg", name="i18n::JsonOutput.name", description="i18n::JsonOutput.description", categoryDescription="i18n::JsonOutput.category", keywords={"i18n::JsonOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/jsonoutput.html")
public class JsonOutputMeta
extends BaseFileOutputMeta<JsonOutput, JsonOutputData> {
    private static final Class<?> PKG = JsonOutputMeta.class;
    @HopMetadataProperty(key="operation_type", injectionKeyDescription="JsonOutput.Injection.OPERATION")
    private String operationType;
    public static final String OPERATION_TYPE_OUTPUT_VALUE = "outputvalue";
    public static final String OPERATION_TYPE_WRITE_TO_FILE = "writetofile";
    public static final String OPERATION_TYPE_BOTH = "both";
    public static final Map<String, String> operationTypeDesc = Map.of("outputvalue", BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.OutputValue", (String[])new String[0]), "writetofile", BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.WriteToFile", (String[])new String[0]), "both", BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.Both", (String[])new String[0]));
    public static final Map<String, String> operationDescType = Map.of(BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.OutputValue", (String[])new String[0]), "outputvalue", BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.WriteToFile", (String[])new String[0]), "writetofile", BaseMessages.getString(PKG, (String)"JsonOutputMeta.operationType.Both", (String[])new String[0]), "both");
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.ENCODING")
    private String encoding;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.OUTPUT_VALUE")
    private String outputValue;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.JSON_BLOC_NAME")
    private String jsonBloc;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.NR_ROWS_IN_BLOC")
    private String nrRowsInBloc;
    @HopMetadataProperty(groupKey="fields", key="field", injectionKey="FIELD", injectionGroupKey="FIELDS", injectionKeyDescription="JsonOutput.Injection.FIELD", injectionGroupDescription="JsonOutput.Injection.FIELDS")
    private List<JsonOutputField> outputFields = new ArrayList<JsonOutputField>();
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.ADD_TO_RESULT")
    private boolean addToResult;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.APPEND")
    private boolean fileAppended;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.CREATE_PARENT_FOLDER")
    private boolean createParentFolder;
    @HopMetadataProperty(injectionKeyDescription="JsonOutput.Injection.DONT_CREATE_AT_START")
    private boolean doNotOpenNewFileInit;

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createParentFolder = createparentfolder;
    }

    public boolean isFileAppended() {
        return this.fileAppended;
    }

    public void setFileAppended(boolean fileAppended) {
        this.fileAppended = fileAppended;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public boolean isAddToResult() {
        return this.addToResult;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public List<JsonOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<JsonOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public Object clone() {
        return super.clone();
    }

    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    public void setDefault() {
        this.encoding = "UTF-8";
        this.outputValue = "outputValue";
        this.jsonBloc = "data";
        this.nrRowsInBloc = "0";
        this.operationType = OPERATION_TYPE_WRITE_TO_FILE;
        this.doNotOpenNewFileInit = true;
        int nrFields = 0;
        for (int i = 0; i < nrFields; ++i) {
            JsonOutputField outputField = new JsonOutputField();
            outputField.setFieldName("field" + i);
            outputField.setElementName("field" + i);
            this.outputFields.add(outputField);
        }
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (!Objects.equals(this.getOperationType(), OPERATION_TYPE_WRITE_TO_FILE)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.getOutputValue()));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (!Objects.equals(this.getOperationType(), OPERATION_TYPE_WRITE_TO_FILE) && Utils.isEmpty((CharSequence)variables.resolve(this.getOutputValue()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingOutputFieldName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)variables.resolve(this.getFileName()))) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutput.Error.MissingTargetFilename", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.outputFields.size(); ++i) {
                int idx = prev.indexOfValue(this.outputFields.get(i).getFieldName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.outputFields.get(i).getFieldName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"JsonOutputMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getJsonBloc() {
        return this.jsonBloc;
    }

    public void setJsonBloc(String jsonBloc) {
        this.jsonBloc = jsonBloc;
    }

    public String getNrRowsInBloc() {
        return this.nrRowsInBloc;
    }

    public void setNrRowsInBloc(String nrRowsInBloc) {
        this.nrRowsInBloc = nrRowsInBloc;
    }

    @Override
    public int getSplitEvery() {
        try {
            return Integer.parseInt(this.getNrRowsInBloc());
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public void setSplitEvery(int splitEvery) {
        this.setNrRowsInBloc("" + splitEvery);
    }

    public String getOutputValue() {
        return this.outputValue;
    }

    public void setOutputValue(String outputValue) {
        this.outputValue = outputValue;
    }
}

