/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ldapinput;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ldapinput.ILdapMeta;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInput;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputData;
import org.apache.hop.pipeline.transforms.ldapinput.LdapInputField;
import org.apache.hop.pipeline.transforms.ldapinput.LdapProtocolFactory;
import org.w3c.dom.Node;

@Transform(id="LDAPInput", name="i18n::LdapInput.Name", description="i18n::LdapInput.Description", image="ldapinput.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::LdapInputMeta.keyword"}, documentationUrl="/pipeline/transforms/ldapinput.html")
public class LdapInputMeta
extends BaseTransformMeta<LdapInput, LdapInputData>
implements ILdapMeta {
    private static final Class<?> PKG = LdapInputMeta.class;
    public static final String CONST_SPACES = "        ";
    public static final String CONST_FIELD = "field";
    private boolean useAuthentication;
    private boolean usePaging;
    private String pagesize;
    private boolean includeRowNumber;
    private String rowNumberField;
    private int rowLimit;
    private String host;
    private String userName;
    private String password;
    private String port;
    private String filterString;
    private String searchBase;
    private LdapInputField[] inputFields;
    private int timeLimit;
    private String multiValuedSeparator;
    private static final String YES = "Y";
    private boolean dynamicSearch;
    private String dynamicSeachFieldName;
    private boolean dynamicFilter;
    private String dynamicFilterFieldName;
    private int searchScope;
    public static final String[] searchScopeDesc = new String[]{BaseMessages.getString(PKG, (String)"LdapInputMeta.SearchScope.Object", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputMeta.SearchScope.OneLevel", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LdapInputMeta.SearchScope.Subtree", (String[])new String[0])};
    public static final String[] searchScopeCode = new String[]{"object", "onelevel", "subtree"};
    private String protocol;
    private boolean useCertificate;
    private String trustStorePath;
    private String trustStorePassword;
    private boolean trustAllCertificates;

    @Override
    public boolean isUseCertificate() {
        return this.useCertificate;
    }

    public void setUseCertificate(boolean value) {
        this.useCertificate = value;
    }

    @Override
    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean value) {
        this.trustAllCertificates = value;
    }

    @Override
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String value) {
        this.trustStorePassword = value;
    }

    @Override
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public void setTrustStorePath(String value) {
        this.trustStorePath = value;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String value) {
        this.protocol = value;
    }

    public boolean isDynamicSearch() {
        return this.dynamicSearch;
    }

    public void setDynamicSearch(boolean dynamicSearch) {
        this.dynamicSearch = dynamicSearch;
    }

    public String getDynamicSearchFieldName() {
        return this.dynamicSeachFieldName;
    }

    public void setDynamicSearchFieldName(String dynamicSeachFieldName) {
        this.dynamicSeachFieldName = dynamicSeachFieldName;
    }

    public boolean isDynamicFilter() {
        return this.dynamicFilter;
    }

    public void setDynamicFilter(boolean dynamicFilter) {
        this.dynamicFilter = dynamicFilter;
    }

    public String getDynamicFilterFieldName() {
        return this.dynamicFilterFieldName;
    }

    public void setDynamicFilterFieldName(String dynamicFilterFieldName) {
        this.dynamicFilterFieldName = dynamicFilterFieldName;
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean useAuthentication) {
        this.useAuthentication = useAuthentication;
    }

    public boolean isPaging() {
        return this.usePaging;
    }

    public void setPaging(boolean usePaging) {
        this.usePaging = usePaging;
    }

    public LdapInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LdapInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setMultiValuedSeparator(String multiValuedSeparator) {
        this.multiValuedSeparator = multiValuedSeparator;
    }

    public String getMultiValuedSeparator() {
        return this.multiValuedSeparator;
    }

    public void setPageSize(String pagesize) {
        this.pagesize = pagesize;
    }

    public String getPageSize() {
        return this.pagesize;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        LdapInputMeta retval = (LdapInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LdapInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    ").append(XmlHandler.addTagValue((String)"usepaging", (boolean)this.usePaging));
        retval.append("    ").append(XmlHandler.addTagValue((String)"pagesize", (String)this.pagesize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"useauthentication", (boolean)this.useAuthentication));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"host", (String)this.host));
        retval.append("    ").append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filterstring", (String)this.filterString));
        retval.append("    ").append(XmlHandler.addTagValue((String)"searchbase", (String)this.searchBase));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"name", (String)this.inputFields[i].getName()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"attribute", (String)this.inputFields[i].getAttribute()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"attribute_fetch_as", (String)this.inputFields[i].getFetchAttributeAsCode()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"sorted_key", (boolean)this.inputFields[i].isSortedKey()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"type", (String)this.inputFields[i].getTypeDesc()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"format", (String)this.inputFields[i].getFormat()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"length", (int)this.inputFields[i].getLength()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"precision", (int)this.inputFields[i].getPrecision()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"currency", (String)this.inputFields[i].getCurrencySymbol()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"decimal", (String)this.inputFields[i].getDecimalSymbol()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"group", (String)this.inputFields[i].getGroupSymbol()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"trim_type", (String)this.inputFields[i].getTrimTypeCode()));
            retval.append(CONST_SPACES).append(XmlHandler.addTagValue((String)"repeat", (boolean)this.inputFields[i].isRepeated()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XmlHandler.addTagValue((String)"limit", (int)this.rowLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"timelimit", (int)this.timeLimit));
        retval.append("    ").append(XmlHandler.addTagValue((String)"multivaluedseparator", (String)this.multiValuedSeparator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicsearch", (boolean)this.dynamicSearch));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicseachfieldname", (String)this.dynamicSeachFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicfilter", (boolean)this.dynamicFilter));
        retval.append("    ").append(XmlHandler.addTagValue((String)"dynamicfilterfieldname", (String)this.dynamicFilterFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"searchScope", (String)LdapInputMeta.getSearchScopeCode(this.searchScope)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStorePath", (String)this.trustStorePath));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustStorePassword", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.trustStorePassword)));
        retval.append("    ").append(XmlHandler.addTagValue((String)"trustAllCertificates", (boolean)this.trustAllCertificates));
        retval.append("    ").append(XmlHandler.addTagValue((String)"useCertificate", (boolean)this.useCertificate));
        return retval.toString();
    }

    private static String getSearchScopeCode(int i) {
        if (i < 0 || i >= searchScopeCode.length) {
            return searchScopeCode[0];
        }
        return searchScopeCode[i];
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.usePaging = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"usepaging"));
            this.pagesize = XmlHandler.getTagValue((Node)transformNode, (String)"pagesize");
            this.useAuthentication = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useauthentication"));
            this.includeRowNumber = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"rownum"));
            this.rowNumberField = XmlHandler.getTagValue((Node)transformNode, (String)"rownum_field");
            this.host = XmlHandler.getTagValue((Node)transformNode, (String)"host");
            this.userName = XmlHandler.getTagValue((Node)transformNode, (String)"username");
            this.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"password")));
            this.port = XmlHandler.getTagValue((Node)transformNode, (String)"port");
            this.filterString = XmlHandler.getTagValue((Node)transformNode, (String)"filterstring");
            this.searchBase = XmlHandler.getTagValue((Node)transformNode, (String)"searchbase");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.inputFields[i] = new LdapInputField();
                this.inputFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)"name"));
                this.inputFields[i].setAttribute(XmlHandler.getTagValue((Node)fnode, (String)"attribute"));
                this.inputFields[i].setFetchAttributeAs(LdapInputField.getFetchAttributeAsByCode(XmlHandler.getTagValue((Node)fnode, (String)"attribute_fetch_as")));
                String sortedkey = XmlHandler.getTagValue((Node)fnode, (String)"sorted_key");
                if (sortedkey != null) {
                    this.inputFields[i].setSortedKey(YES.equalsIgnoreCase(sortedkey));
                } else {
                    this.inputFields[i].setSortedKey(false);
                }
                this.inputFields[i].setType(ValueMetaFactory.getIdForValueMeta((String)XmlHandler.getTagValue((Node)fnode, (String)"type")));
                this.inputFields[i].setLength(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.inputFields[i].setPrecision(Const.toInt((String)XmlHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                String srepeat = XmlHandler.getTagValue((Node)fnode, (String)"repeat");
                if (srepeat != null) {
                    this.inputFields[i].setRepeated(YES.equalsIgnoreCase(srepeat));
                } else {
                    this.inputFields[i].setRepeated(false);
                }
                this.inputFields[i].setTrimType(ValueMetaBase.getTrimTypeByCode((String)XmlHandler.getTagValue((Node)fnode, (String)"trim_type")));
                this.inputFields[i].setFormat(XmlHandler.getTagValue((Node)fnode, (String)"format"));
                this.inputFields[i].setCurrencySymbol(XmlHandler.getTagValue((Node)fnode, (String)"currency"));
                this.inputFields[i].setDecimalSymbol(XmlHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.inputFields[i].setGroupSymbol(XmlHandler.getTagValue((Node)fnode, (String)"group"));
            }
            this.rowLimit = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"limit"), (int)0);
            this.timeLimit = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"timelimit"), (int)0);
            this.multiValuedSeparator = XmlHandler.getTagValue((Node)transformNode, (String)"multivaluedseparator");
            this.dynamicSearch = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicsearch"));
            this.dynamicSeachFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"dynamicseachfieldname");
            this.dynamicFilter = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicfilter"));
            this.dynamicFilterFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"dynamicfilterfieldname");
            this.searchScope = LdapInputMeta.getSearchScopeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)"searchScope"), (String)LdapInputMeta.getSearchScopeCode(2)));
            this.protocol = XmlHandler.getTagValue((Node)transformNode, (String)"protocol");
            this.trustStorePath = XmlHandler.getTagValue((Node)transformNode, (String)"trustStorePath");
            this.trustStorePassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)transformNode, (String)"trustStorePassword"));
            this.trustAllCertificates = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"trustAllCertificates"));
            this.useCertificate = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"useCertificate"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"LdapInputMeta.UnableToLoadFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static int getSearchScopeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < searchScopeCode.length; ++i) {
            if (!searchScopeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void allocate(int nrFields) {
        this.inputFields = new LdapInputField[nrFields];
    }

    public void setDefault() {
        this.usePaging = false;
        this.pagesize = "1000";
        this.useAuthentication = false;
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.host = "";
        this.userName = "";
        this.password = "";
        this.port = "389";
        this.filterString = "objectclass=*";
        this.searchBase = "";
        this.multiValuedSeparator = ";";
        this.dynamicSearch = false;
        this.dynamicSeachFieldName = null;
        this.dynamicFilter = false;
        this.dynamicFilterFieldName = null;
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LdapInputField(CONST_FIELD + (i + 1));
        }
        this.rowLimit = 0;
        this.timeLimit = 0;
        this.searchScope = 2;
        this.trustStorePath = null;
        this.trustStorePassword = null;
        this.trustAllCertificates = false;
        this.protocol = LdapProtocolFactory.getConnectionTypes(this.log).get(0);
        this.useCertificate = false;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.inputFields.length; ++i) {
            LdapInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)variables.resolve(field.getName()), (int)type);
                v.setLength(field.getLength(), field.getPrecision());
                v.setOrigin(name);
                r.addValueMeta(v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.includeRowNumber) {
            ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public static String getSearchScopeDesc(int i) {
        if (i < 0 || i >= searchScopeDesc.length) {
            return searchScopeDesc[0];
        }
        return searchScopeDesc[i];
    }

    public static int getSearchScopeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < searchScopeDesc.length; ++i) {
            if (!searchScopeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return LdapInputMeta.getSearchScopeByCode(tt);
    }

    public void setSearchScope(int value) {
        this.searchScope = value;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = this.inputFields.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.NoOutputFields", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.OutputFieldsOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = Utils.isEmpty((CharSequence)this.host) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.HostnameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.HostnameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.isDynamicSearch()) {
            cr = Utils.isEmpty((CharSequence)this.dynamicSeachFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.DynamicSearchBaseFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.DynamicSearchBaseFieldNameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.searchBase) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.SearchBaseMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.SearchBaseOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isDynamicFilter()) {
            cr = Utils.isEmpty((CharSequence)this.dynamicFilterFieldName) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.DynamicFilterFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.DynamicFilterFieldNameOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = Utils.isEmpty((CharSequence)this.filterString) ? new CheckResult(3, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.FilterStringMissing", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"LdapInputMeta.CheckResult.FilterStringOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String toString() {
        return "LDAPConnection " + this.getName();
    }

    @Override
    public String getDerefAliases() {
        return "always";
    }

    @Override
    public String getReferrals() {
        return "follow";
    }
}

