/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access.list;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.list.OpenListEnumeration;
import com.ibm.as400.access.list.OpenListException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class OpenList
implements Serializable {
    static final long serialVersionUID = -5967313807836097042L;
    protected static final ProgramParameter EMPTY_ERROR_CODE_PARM = new ErrorCodeParameter();
    protected AS400 system_;
    private int length_;
    private int enumerationBlockSize_ = 1000;
    private byte[] handle_;
    private boolean closeHandle_ = false;
    private Vector enumerations_;

    protected OpenList(AS400 system) {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Constructing OpenList object, system: " + system);
        }
        if (system == null) {
            Trace.log(2, "Parameter 'system' is null.");
            throw new NullPointerException("system");
        }
        this.system_ = system;
    }

    protected abstract byte[] callOpenListAPI() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException;

    public synchronized void close() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Closing open list, handle: ", this.handle_);
        }
        if (this.handle_ == null) {
            return;
        }
        try {
            ProgramParameter[] parameters;
            ProgramCall pc;
            if (this.enumerations_ != null) {
                for (int i = this.enumerations_.size() - 1; i >= 0; --i) {
                    OpenListEnumeration element = (OpenListEnumeration)this.enumerations_.elementAt(i);
                    element.close();
                }
                this.enumerations_ = null;
            }
            if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYCLST.PGM", parameters = new ProgramParameter[]{new ProgramParameter(this.handle_), EMPTY_ERROR_CODE_PARM})).run()) {
                throw new AS400Exception(pc.getMessageList());
            }
        }
        finally {
            this.handle_ = null;
            this.closeHandle_ = false;
        }
    }

    protected void finalize() throws Throwable {
        block4: {
            if (Trace.isTraceOn()) {
                Trace.log(1, "Finalize method for open list invoked.");
            }
            try {
                if (this.system_.isConnected(2)) {
                    this.close();
                }
            }
            catch (Exception e) {
                if (!Trace.isTraceOn()) break block4;
                Trace.log(1, "Exception occurred while finalizing open list with handle:", this.handle_);
                Trace.log(2, e);
            }
        }
        super.finalize();
    }

    protected abstract Object[] formatOutputData(byte[] var1, int var2, int var3) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException;

    protected abstract int getBestGuessReceiverSize(int var1);

    public int getEnumerationBlockSize() {
        return this.enumerationBlockSize_;
    }

    public synchronized int getLength() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Getting open list length.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (Trace.isTraceOn()) {
            Trace.log(1, "Length:", this.length_);
        }
        return this.length_;
    }

    public synchronized Enumeration getItems() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving open list.");
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (this.enumerations_ == null) {
            this.enumerations_ = new Vector();
        }
        OpenListEnumeration items = new OpenListEnumeration(this, this.length_);
        this.enumerations_.addElement(items);
        return items;
    }

    public synchronized Object[] getItems(int listOffset, int number) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "Retrieving open list, list offset: " + listOffset + ", number:", number);
        }
        if (listOffset < -1) {
            Trace.log(2, "Value of parameter 'listOffset' is not valid:", listOffset);
            throw new ExtendedIllegalArgumentException("listOffset (" + listOffset + ")", 4);
        }
        if (number < 0 && listOffset != -1) {
            Trace.log(2, "Value of parameter 'number' is not valid:", number);
            throw new ExtendedIllegalArgumentException("number (" + number + ")", 4);
        }
        if (this.handle_ == null || this.closeHandle_) {
            this.open();
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else if (listOffset + number > this.length_) {
            number = this.length_ - listOffset;
        }
        int lengthOfReceiverVariable = this.getBestGuessReceiverSize(number);
        ProgramParameter[] parameters = new ProgramParameter[]{new ProgramParameter(lengthOfReceiverVariable), new ProgramParameter(BinaryConverter.intToByteArray(lengthOfReceiverVariable)), new ProgramParameter(this.handle_), new ProgramParameter(80), new ProgramParameter(BinaryConverter.intToByteArray(number)), new ProgramParameter(BinaryConverter.intToByteArray(listOffset + 1)), EMPTY_ERROR_CODE_PARM};
        ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYGTLE.PGM", parameters);
        byte[] listInformation = null;
        int recordsReturned = 0;
        do {
            if (pc.run()) {
                listInformation = parameters[3].getOutputData();
                recordsReturned = BinaryConverter.byteArrayToInt(listInformation, 4);
            } else {
                AS400Message[] messages = pc.getMessageList();
                if (!messages[0].getID().equals("GUI0002")) {
                    throw new AS400Exception(messages);
                }
            }
            if (recordsReturned >= number) continue;
            if (Trace.isTraceOn()) {
                Trace.log(1, "Retrieved messages, records returned: " + recordsReturned + ", number:", number);
            }
            lengthOfReceiverVariable *= 1 + number / (recordsReturned + 1);
            if (Trace.isTraceOn()) {
                Trace.log(1, "Updated length: ", lengthOfReceiverVariable);
            }
            parameters[0] = new ProgramParameter(lengthOfReceiverVariable);
            parameters[1] = new ProgramParameter(BinaryConverter.intToByteArray(lengthOfReceiverVariable));
        } while (recordsReturned < number || listInformation == null);
        int recordLength = BinaryConverter.byteArrayToInt(listInformation, 12);
        int listStatusIndicator = listInformation[30] & 0xFF;
        if (listStatusIndicator != 242) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to build object list on server, list status indicator:", listStatusIndicator);
            }
            throw new OpenListException(listStatusIndicator);
        }
        return this.formatOutputData(parameters[0].getOutputData(), recordsReturned, recordLength);
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public boolean isOpen() {
        return this.handle_ == null || this.closeHandle_;
    }

    public synchronized void open() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, OpenListException {
        byte[] listInformation;
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opening object list.");
        }
        if (this.closeHandle_) {
            this.close();
        }
        if ((listInformation = this.callOpenListAPI()) == null || listInformation.length < 30) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Bad list information returned:", listInformation);
            }
            throw new OpenListException(0x100000);
        }
        int listStatusIndicator = listInformation[30] & 0xFF;
        if (listStatusIndicator != 242) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Unable to build object list on server, list status indicator:", listStatusIndicator);
            }
            throw new OpenListException(listStatusIndicator);
        }
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        if (Trace.isTraceOn()) {
            Trace.log(1, "Opened object list, length: " + this.length_ + ", record length: " + BinaryConverter.byteArrayToInt(listInformation, 12) + ", handle:", this.handle_);
        }
    }

    void remove(OpenListEnumeration enum1) {
        this.enumerations_.removeElement(enum1);
    }

    protected synchronized void resetHandle() {
        if (this.handle_ != null) {
            this.closeHandle_ = true;
        }
    }

    public void setEnumerationBlockSize(int enumerationBlockSize) {
        this.enumerationBlockSize_ = enumerationBlockSize < 1 ? 1000 : enumerationBlockSize;
    }
}

