/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.auth;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.cassandra.auth.CassandraAuthorizer;
import org.apache.cassandra.auth.DCPermissions;
import org.apache.cassandra.auth.INetworkAuthorizer;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.auth.Roles;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.transport.messages.ResultMessage;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraNetworkAuthorizer
implements INetworkAuthorizer {
    private static final Logger logger = LoggerFactory.getLogger(CassandraNetworkAuthorizer.class);
    private SelectStatement authorizeUserStatement = null;

    @Override
    public void setup() {
        String query = String.format("SELECT dcs FROM %s.%s WHERE role = ?", "system_auth", "network_permissions");
        this.authorizeUserStatement = (SelectStatement)QueryProcessor.getStatement(query, ClientState.forInternalCalls());
    }

    @VisibleForTesting
    ResultMessage.Rows select(SelectStatement statement, QueryOptions options) {
        return statement.execute(QueryState.forInternalCalls(), options, Dispatcher.RequestTime.forImmediateExecution());
    }

    @VisibleForTesting
    UntypedResultSet process(String query, ConsistencyLevel cl) throws RequestExecutionException {
        return QueryProcessor.process(query, cl);
    }

    private Set<String> getAuthorizedDcs(String name) {
        QueryOptions options = QueryOptions.forInternalCalls(CassandraAuthorizer.authReadConsistencyLevel(), Lists.newArrayList((Object[])new ByteBuffer[]{ByteBufferUtil.bytes(name)}));
        ResultMessage.Rows rows = this.select(this.authorizeUserStatement, options);
        UntypedResultSet result = UntypedResultSet.create(rows.result);
        Set<String> dcs = null;
        if (!result.isEmpty() && result.one().has("dcs")) {
            dcs = result.one().getFrozenSet("dcs", UTF8Type.instance);
        }
        return dcs;
    }

    @Override
    public DCPermissions authorize(RoleResource role) {
        if (!Roles.canLogin(role)) {
            return DCPermissions.none();
        }
        if (Roles.hasSuperuserStatus(role)) {
            return DCPermissions.all();
        }
        Set<String> dcs = this.getAuthorizedDcs(role.getName());
        if (dcs == null || dcs.isEmpty()) {
            return DCPermissions.all();
        }
        return DCPermissions.subset(dcs);
    }

    private static String getSetString(DCPermissions permissions) {
        if (permissions.restrictsAccess()) {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            boolean first = true;
            for (String dc : permissions.allowedDCs()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append('\'');
                builder.append(dc);
                builder.append('\'');
            }
            builder.append('}');
            return builder.toString();
        }
        return "{}";
    }

    @Override
    public void setRoleDatacenters(RoleResource role, DCPermissions permissions) {
        String query = String.format("UPDATE %s.%s SET dcs = %s WHERE role = '%s'", "system_auth", "network_permissions", CassandraNetworkAuthorizer.getSetString(permissions), role.getName());
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @Override
    public void drop(RoleResource role) {
        String query = String.format("DELETE FROM %s.%s WHERE role = '%s'", "system_auth", "network_permissions", role.getName());
        this.process(query, CassandraAuthorizer.authWriteConsistencyLevel());
    }

    @Override
    public void validateConfiguration() throws ConfigurationException {
    }

    @Override
    public Supplier<Map<RoleResource, DCPermissions>> bulkLoader() {
        return () -> {
            logger.info("Pre-warming datacenter permissions cache from network_permissions table");
            HashMap<RoleResource, DCPermissions> entries = new HashMap<RoleResource, DCPermissions>();
            UntypedResultSet rows = this.process(String.format("SELECT role, dcs FROM %s.%s", "system_auth", "network_permissions"), CassandraAuthorizer.authReadConsistencyLevel());
            for (UntypedResultSet.Row row : rows) {
                RoleResource role = RoleResource.role(row.getString("role"));
                DCPermissions.Builder builder = new DCPermissions.Builder();
                Set<String> dcs = row.getFrozenSet("dcs", UTF8Type.instance);
                for (String dc : dcs) {
                    builder.add(dc);
                }
                entries.put(role, builder.build());
            }
            return entries;
        };
    }
}

