/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.cloudjdbc;

import com.xugu.common.ReplaceEnum;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogWriter {
    private BufferedWriter bw = null;
    private static StringBuffer logName = null;
    private static LogWriter lw = null;

    public static LogWriter getInstance() {
        if (lw == null) {
            try {
                logName = new StringBuffer(ReplaceEnum.logHeadName.getReplaceStr());
                logName.append(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
                String logFilePath = System.getProperty("user.dir");
                File logFoleder = new File(logFilePath + File.separator + "log");
                if (!logFoleder.exists()) {
                    logFoleder.mkdirs();
                }
                File file = new File(logFoleder.getAbsolutePath() + File.separator + logName.toString() + ".log");
                lw = new LogWriter(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return lw;
    }

    private LogWriter(File file) {
        try {
            this.bw = new BufferedWriter(new FileWriter(file, true));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public void write(int sessionId, String str, CmdState level, long exeTime) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 23[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void write(int sessionId, String str, CmdState level) {
        this.write(sessionId, str, level, 0L);
    }

    public void write(String str) {
        try {
            this.bw.write(str);
            this.bw.flush();
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        LogWriter.getInstance();
    }

    public static enum CmdState {
        beginHandshake(0),
        serverUrl(1),
        loginUrl(2),
        buildNewConnection(3),
        connectError(4),
        beginNormal(10),
        beginPre(11),
        beginPreCall(12),
        callPre(13),
        serverSQL(14),
        innerPara(20),
        serverPara(21),
        normalRecvTurn(30),
        paramRecv(31),
        endCmd(40),
        endRecv(41),
        batchSQL(42),
        blockState(100),
        stOverState(101),
        rsOverState(102),
        endK(50),
        endEF(51),
        endWM(52),
        dmMethod(200),
        pstMethod(201),
        rsMethod(202),
        closeMethod(203),
        slowSQLRecord(300),
        violateProtocol(2220),
        Other(2222),
        debug(2223);

        private int state;

        private CmdState(int state) {
            this.state = state;
        }
    }
}

