/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.util.ArrowBufPointer;
import org.apache.arrow.memory.util.ByteFunctionHelpers;
import org.apache.arrow.memory.util.CommonUtil;
import org.apache.arrow.memory.util.LargeMemoryUtil;
import org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BaseValueVector;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.BufferBacked;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VariableWidthFieldVector;
import org.apache.arrow.vector.compare.VectorVisitor;
import org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.util.CallBack;
import org.apache.arrow.vector.util.OversizedAllocationException;
import org.apache.arrow.vector.util.TransferPair;

public abstract class BaseVariableWidthVector
extends BaseValueVector
implements VariableWidthFieldVector {
    private static final int DEFAULT_RECORD_BYTE_COUNT = 8;
    private static final int INITIAL_BYTE_COUNT = 31760;
    private static final int MAX_BUFFER_SIZE = (int)Math.min(MAX_ALLOCATION_SIZE, Integer.MAX_VALUE);
    private int lastValueCapacity;
    private long lastValueAllocationSizeInBytes;
    public static final int OFFSET_WIDTH = 4;
    protected static final byte[] emptyByteArray = new byte[0];
    protected ArrowBuf validityBuffer;
    protected ArrowBuf valueBuffer;
    protected ArrowBuf offsetBuffer;
    protected int valueCount;
    protected int lastSet;
    protected final Field field;

    public BaseVariableWidthVector(Field field, BufferAllocator allocator) {
        super(allocator);
        this.field = field;
        this.lastValueAllocationSizeInBytes = 31760L;
        this.lastValueCapacity = 3969;
        this.valueCount = 0;
        this.lastSet = -1;
        this.offsetBuffer = allocator.getEmpty();
        this.validityBuffer = allocator.getEmpty();
        this.valueBuffer = allocator.getEmpty();
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        return this.valueBuffer;
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        return this.offsetBuffer;
    }

    @Override
    public long getOffsetBufferAddress() {
        return this.offsetBuffer.memoryAddress();
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        return this.valueBuffer.memoryAddress();
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 8L;
        this.checkDataBufferSize(size);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    @Override
    public void setInitialCapacity(int valueCount, double density) {
        long size = Math.max((long)((double)valueCount * density), 1L);
        this.checkDataBufferSize(size);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.lastValueAllocationSizeInBytes = (int)size;
        this.lastValueCapacity = valueCount;
    }

    public double getDensity() {
        if (this.valueCount == 0) {
            return 0.0;
        }
        int startOffset = this.getStartOffset(0);
        int endOffset = this.getStartOffset(this.valueCount);
        double totalListSize = endOffset - startOffset;
        return totalListSize / (double)this.valueCount;
    }

    @Override
    public int getValueCapacity() {
        int offsetValueCapacity = Math.max(this.getOffsetBufferValueCapacity() - 1, 0);
        return Math.min(offsetValueCapacity, this.getValidityBufferValueCapacity());
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt((long)(this.validityBuffer.capacity() * 8L));
    }

    private int getOffsetBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt((long)(this.offsetBuffer.capacity() / 4L));
    }

    public void zeroVector() {
        this.initValidityBuffer();
        this.initOffsetBuffer();
        this.valueBuffer.setZero(0L, this.valueBuffer.capacity());
    }

    private void initValidityBuffer() {
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    private void initOffsetBuffer() {
        this.offsetBuffer.setZero(0L, this.offsetBuffer.capacity());
    }

    @Override
    public void reset() {
        this.zeroVector();
        this.lastSet = -1;
        this.valueCount = 0;
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.valueBuffer = this.releaseBuffer(this.valueBuffer);
        this.offsetBuffer = this.releaseBuffer(this.offsetBuffer);
        this.lastSet = -1;
        this.valueCount = 0;
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("primitive type vector cannot have children");
        }
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.emptyList();
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        ArrowBuf bitBuffer = ownBuffers.get(0);
        ArrowBuf offBuffer = ownBuffers.get(1);
        ArrowBuf dataBuffer = ownBuffers.get(2);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.offsetBuffer.getReferenceManager().release();
        this.offsetBuffer = offBuffer.getReferenceManager().retain(offBuffer, this.allocator);
        this.valueBuffer.getReferenceManager().release();
        this.valueBuffer = dataBuffer.getReferenceManager().retain(dataBuffer, this.allocator);
        this.lastSet = fieldNode.getLength() - 1;
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        this.fillHoles(this.valueCount);
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(3);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        result.add(this.offsetBuffer);
        result.add(this.valueBuffer);
        return result;
    }

    @Override
    public void exportCDataBuffers(List<ArrowBuf> buffers, ArrowBuf buffersPtr, long nullValue) {
        this.fillHoles(this.valueCount);
        this.exportBuffer(this.validityBuffer, buffers, buffersPtr, nullValue, true);
        if (this.offsetBuffer.capacity() == 0L) {
            this.exportBuffer(this.allocateOffsetBuffer(4L), buffers, buffersPtr, nullValue, false);
        } else {
            this.exportBuffer(this.offsetBuffer, buffers, buffersPtr, nullValue, true);
        }
        this.exportBuffer(this.valueBuffer, buffers, buffersPtr, nullValue, true);
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.offsetBuffer.readerIndex(0L);
        this.valueBuffer.readerIndex(0L);
        if (this.valueCount == 0) {
            this.validityBuffer.writerIndex(0L);
            this.offsetBuffer.writerIndex(0L);
            this.valueBuffer.writerIndex(0L);
        } else {
            int lastDataOffset = this.getStartOffset(this.valueCount);
            this.validityBuffer.writerIndex((long)BaseVariableWidthVector.getValidityBufferSizeFromCount(this.valueCount));
            this.offsetBuffer.writerIndex((long)(this.valueCount + 1) * 4L);
            this.valueBuffer.writerIndex((long)lastDataOffset);
        }
    }

    @Override
    public void allocateNew() {
        this.allocateNew(this.lastValueAllocationSizeInBytes, this.lastValueCapacity);
    }

    @Override
    public boolean allocateNewSafe() {
        try {
            this.allocateNew(this.lastValueAllocationSizeInBytes, this.lastValueCapacity);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void allocateNew(long totalBytes, int valueCount) {
        assert (totalBytes >= 0L);
        this.checkDataBufferSize(totalBytes);
        this.computeAndCheckOffsetsBufferSize(valueCount);
        this.clear();
        try {
            this.allocateBytes(totalBytes, valueCount);
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateNew(this.lastValueAllocationSizeInBytes, valueCount);
    }

    private void checkDataBufferSize(long size) {
        if (size > (long)MAX_BUFFER_SIZE || size < 0L) {
            throw new OversizedAllocationException("Memory required for vector is (" + size + "), which is overflow or more than max allowed (" + MAX_BUFFER_SIZE + "). You could consider using LargeVarCharVector/LargeVarBinaryVector for large strings/large bytes types");
        }
    }

    private long computeAndCheckOffsetsBufferSize(int valueCount) {
        long size = this.computeCombinedBufferSize(valueCount + 1, 4);
        if (size > (long)MAX_BUFFER_SIZE) {
            throw new OversizedAllocationException("Memory required for vector capacity " + valueCount + " is (" + size + "), which is more than max allowed (" + MAX_BUFFER_SIZE + ")");
        }
        return size;
    }

    private void allocateBytes(long valueBufferSize, int valueCount) {
        long curSize = valueBufferSize;
        this.valueBuffer = this.allocator.buffer(curSize);
        this.valueBuffer.readerIndex(0L);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(valueCount + 1, 4);
        this.offsetBuffer = buffers.getDataBuf();
        this.validityBuffer = buffers.getValidityBuf();
        this.initOffsetBuffer();
        this.initValidityBuffer();
        this.lastValueCapacity = this.getValueCapacity();
        this.lastValueAllocationSizeInBytes = LargeMemoryUtil.capAtMaxInt((long)this.valueBuffer.capacity());
    }

    private ArrowBuf allocateOffsetBuffer(long size) {
        int curSize = (int)size;
        ArrowBuf offsetBuffer = this.allocator.buffer((long)curSize);
        offsetBuffer.readerIndex(0L);
        this.initOffsetBuffer();
        return offsetBuffer;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer((long)curSize);
        this.validityBuffer.readerIndex(0L);
        this.initValidityBuffer();
    }

    @Override
    public void reAlloc() {
        this.reallocDataBuffer();
        this.reallocValidityAndOffsetBuffers();
    }

    public void reallocDataBuffer() {
        long currentBufferCapacity = this.valueBuffer.capacity();
        long newAllocationSize = currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.lastValueAllocationSizeInBytes > 0L ? this.lastValueAllocationSizeInBytes : 63520L;
        }
        this.reallocDataBuffer(newAllocationSize);
    }

    public void reallocDataBuffer(long desiredAllocSize) {
        if (desiredAllocSize == 0L) {
            return;
        }
        long newAllocationSize = CommonUtil.nextPowerOfTwo((long)desiredAllocSize);
        assert (newAllocationSize >= 1L);
        this.checkDataBufferSize(newAllocationSize);
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.valueBuffer, 0L, this.valueBuffer.capacity());
        this.valueBuffer.getReferenceManager().release();
        this.valueBuffer = newBuf;
        this.lastValueAllocationSizeInBytes = this.valueBuffer.capacity();
    }

    public void reallocValidityAndOffsetBuffers() {
        int targetOffsetCount = LargeMemoryUtil.capAtMaxInt((long)(this.offsetBuffer.capacity() / 4L * 2L));
        if (targetOffsetCount == 0) {
            targetOffsetCount = this.lastValueCapacity > 0 ? this.lastValueCapacity + 1 : 7942;
        }
        this.computeAndCheckOffsetsBufferSize(targetOffsetCount);
        BaseValueVector.DataAndValidityBuffers buffers = this.allocFixedDataAndValidityBufs(targetOffsetCount, 4);
        ArrowBuf newOffsetBuffer = buffers.getDataBuf();
        newOffsetBuffer.setBytes(0L, this.offsetBuffer, 0L, this.offsetBuffer.capacity());
        newOffsetBuffer.setZero(this.offsetBuffer.capacity(), newOffsetBuffer.capacity() - this.offsetBuffer.capacity());
        this.offsetBuffer.getReferenceManager().release();
        this.offsetBuffer = newOffsetBuffer;
        ArrowBuf newValidityBuffer = buffers.getValidityBuf();
        newValidityBuffer.setBytes(0L, this.validityBuffer, 0L, this.validityBuffer.capacity());
        newValidityBuffer.setZero(this.validityBuffer.capacity(), newValidityBuffer.capacity() - this.validityBuffer.capacity());
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = newValidityBuffer;
        this.lastValueCapacity = this.getValueCapacity();
    }

    @Override
    public int getByteCapacity() {
        return LargeMemoryUtil.capAtMaxInt((long)this.valueBuffer.capacity());
    }

    @Override
    public int sizeOfValueBuffer() {
        if (this.valueCount == 0) {
            return 0;
        }
        return this.offsetBuffer.getInt((long)this.valueCount * 4L);
    }

    @Override
    public int getBufferSize() {
        return this.getBufferSizeFor(this.valueCount);
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int validityBufferSize = BaseVariableWidthVector.getValidityBufferSizeFromCount(valueCount);
        int offsetBufferSize = (valueCount + 1) * 4;
        int dataBufferSize = this.offsetBuffer.getInt((long)valueCount * 4L);
        return validityBufferSize + offsetBufferSize + dataBufferSize;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        this.setReaderAndWriterIndex();
        ArrowBuf[] buffers = this.getBufferSize() == 0 ? new ArrowBuf[]{} : new ArrowBuf[]{this.validityBuffer, this.offsetBuffer, this.valueBuffer};
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    public void validateScalars() {
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(field, allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return this.getTransferPair(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return this.getTransferPair(this.getName(), allocator);
    }

    @Override
    public abstract TransferPair getTransferPair(String var1, BufferAllocator var2);

    @Override
    public abstract TransferPair getTransferPair(Field var1, BufferAllocator var2);

    public void transferTo(BaseVariableWidthVector target) {
        this.compareTypes(target, "transferTo");
        target.clear();
        target.validityBuffer = BaseVariableWidthVector.transferBuffer(this.validityBuffer, target.allocator);
        target.valueBuffer = BaseVariableWidthVector.transferBuffer(this.valueBuffer, target.allocator);
        target.offsetBuffer = BaseVariableWidthVector.transferBuffer(this.offsetBuffer, target.allocator);
        target.setLastSet(this.lastSet);
        if (this.valueCount > 0) {
            target.setValueCount(this.valueCount);
        }
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, BaseVariableWidthVector target) {
        Preconditions.checkArgument((startIndex >= 0 && length >= 0 && startIndex + length <= this.valueCount ? 1 : 0) != 0, (String)"Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)this.valueCount);
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        if (length > 0) {
            this.splitAndTransferValidityBuffer(startIndex, length, target);
            this.splitAndTransferOffsetBuffer(startIndex, length, target);
            target.setLastSet(length - 1);
            target.setValueCount(length);
        }
    }

    private void splitAndTransferOffsetBuffer(int startIndex, int length, BaseVariableWidthVector target) {
        int start = this.getStartOffset(startIndex);
        int end = this.getStartOffset(startIndex + length);
        int dataLength = end - start;
        if (start == 0) {
            ArrowBuf slicedOffsetBuffer = this.offsetBuffer.slice((long)startIndex * 4L, (long)(1 + length) * 4L);
            target.offsetBuffer = BaseVariableWidthVector.transferBuffer(slicedOffsetBuffer, target.allocator);
        } else {
            target.offsetBuffer = target.allocateOffsetBuffer((long)(length + 1) * 4L);
            for (int i = 0; i < length + 1; ++i) {
                int relativeSourceOffset = this.getStartOffset(startIndex + i) - start;
                target.offsetBuffer.setInt((long)i * 4L, relativeSourceOffset);
            }
        }
        ArrowBuf slicedBuffer = this.valueBuffer.slice((long)start, (long)dataLength);
        target.valueBuffer = BaseVariableWidthVector.transferBuffer(slicedBuffer, target.allocator);
    }

    private void splitAndTransferValidityBuffer(int startIndex, int length, BaseVariableWidthVector target) {
        byte b1;
        if (length <= 0) {
            return;
        }
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BaseVariableWidthVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (offset == 0) {
            if (target.validityBuffer != null) {
                target.validityBuffer.getReferenceManager().release();
            }
            ArrowBuf slicedValidityBuffer = this.validityBuffer.slice((long)firstByteSource, (long)byteSizeTarget);
            target.validityBuffer = BaseVariableWidthVector.transferBuffer(slicedValidityBuffer, target.allocator);
            return;
        }
        target.allocateValidityBuffer(byteSizeTarget);
        for (int i = 0; i < byteSizeTarget - 1; ++i) {
            byte b12 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + i, offset);
            byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + i + 1, offset);
            target.validityBuffer.setByte((long)i, b12 + b2);
        }
        if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
            b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
            byte b2 = BitVectorHelper.getBitsFromNextByte(this.validityBuffer, firstByteSource + byteSizeTarget, offset);
            target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
        } else {
            b1 = BitVectorHelper.getBitsFromCurrentByte(this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
            target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
        }
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    public boolean isSafe(int index) {
        return index < this.getValueCapacity();
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte((long)byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        assert (valueCount >= 0);
        this.valueCount = valueCount;
        while (valueCount > this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        this.fillHoles(valueCount);
        this.lastSet = valueCount - 1;
        this.setReaderAndWriterIndex();
    }

    @Override
    public void fillEmpties(int index) {
        this.handleSafe(index, emptyByteArray.length);
        this.fillHoles(index);
        this.lastSet = index - 1;
    }

    @Override
    public void setLastSet(int value) {
        this.lastSet = value;
    }

    @Override
    public int getLastSet() {
        return this.lastSet;
    }

    public long getStartEnd(int index) {
        return this.offsetBuffer.getLong((long)index * 4L);
    }

    @Override
    public void setIndexDefined(int index) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
    }

    @Override
    public void setValueLengthSafe(int index, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.fillHoles(index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        this.lastSet = index;
    }

    @Override
    public int getValueLength(int index) {
        assert (index >= 0);
        if (this.isSet(index) == 0) {
            return 0;
        }
        int startOffset = this.getStartOffset(index);
        int dataLength = this.getEndOffset(index) - startOffset;
        return dataLength;
    }

    @Override
    public void set(int index, byte[] value) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, byte[] value) {
        assert (index >= 0);
        this.handleSafe(index, value.length);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, 0, value.length);
        this.lastSet = index;
    }

    @Override
    public void set(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, byte[] value, int start, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setBytes(index, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void set(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        this.valueBuffer.setBytes((long)startOffset, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void setSafe(int index, ByteBuffer value, int start, int length) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        this.valueBuffer.setBytes((long)startOffset, value, start, length);
        this.lastSet = index;
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    public void set(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        int startOffset = this.offsetBuffer.getInt((long)index * 4L);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, buffer, (long)start, (long)dataLength);
        this.lastSet = index;
    }

    public void setSafe(int index, int isSet, int start, int end, ArrowBuf buffer) {
        assert (index >= 0);
        int dataLength = end - start;
        this.handleSafe(index, dataLength);
        this.fillHoles(index);
        BitVectorHelper.setValidityBit(this.validityBuffer, index, isSet);
        int startOffset = this.offsetBuffer.getInt((long)index * 4L);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + dataLength);
        this.valueBuffer.setBytes((long)startOffset, buffer, (long)start, (long)dataLength);
        this.lastSet = index;
    }

    public void set(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.offsetBuffer.getInt((long)index * 4L);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        ArrowBuf bb = buffer.slice((long)start, (long)length);
        this.valueBuffer.setBytes((long)startOffset, bb);
        this.lastSet = index;
    }

    public void setSafe(int index, int start, int length, ArrowBuf buffer) {
        assert (index >= 0);
        this.handleSafe(index, length);
        this.fillHoles(index);
        BitVectorHelper.setBit(this.validityBuffer, index);
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        ArrowBuf bb = buffer.slice((long)start, (long)length);
        this.valueBuffer.setBytes((long)startOffset, bb);
        this.lastSet = index;
    }

    protected final void fillHoles(int index) {
        for (int i = this.lastSet + 1; i < index; ++i) {
            this.setBytes(i, emptyByteArray, 0, emptyByteArray.length);
        }
        this.lastSet = index - 1;
    }

    protected final void setBytes(int index, byte[] value, int start, int length) {
        int startOffset = this.getStartOffset(index);
        this.offsetBuffer.setInt((long)(index + 1) * 4L, startOffset + length);
        this.valueBuffer.setBytes((long)startOffset, value, start, (long)length);
    }

    public final int getStartOffset(int index) {
        return this.offsetBuffer.getInt((long)index * 4L);
    }

    protected final void handleSafe(int index, int dataLength) {
        while (index >= this.getValueCapacity()) {
            this.reallocValidityAndOffsetBuffers();
        }
        long startOffset = this.lastSet < 0 ? 0L : (long)this.getStartOffset(this.lastSet + 1);
        long targetCapacity = startOffset + (long)dataLength;
        if (this.valueBuffer.capacity() < targetCapacity) {
            this.reallocDataBuffer(targetCapacity);
        }
    }

    public static byte[] get(ArrowBuf data, ArrowBuf offset, int index) {
        int currentStartOffset = offset.getInt((long)index * 4L);
        int dataLength = offset.getInt((long)(index + 1) * 4L) - currentStartOffset;
        byte[] result = new byte[dataLength];
        data.getBytes((long)currentStartOffset, result, 0, dataLength);
        return result;
    }

    public static ArrowBuf set(ArrowBuf buffer, BufferAllocator allocator, int valueCount, int index, int value) {
        if (buffer == null) {
            buffer = allocator.buffer((long)valueCount * 4L);
        }
        buffer.setInt((long)index * 4L, value);
        if (index == valueCount - 1) {
            buffer.writerIndex((long)valueCount * 4L);
        }
        return buffer;
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument((this.getMinorType() == from.getMinorType() ? 1 : 0) != 0);
        if (from.isNull(fromIndex)) {
            this.fillHoles(thisIndex);
            BitVectorHelper.unsetBit(this.validityBuffer, thisIndex);
            int copyStart = this.offsetBuffer.getInt((long)thisIndex * 4L);
            this.offsetBuffer.setInt((long)(thisIndex + 1) * 4L, copyStart);
        } else {
            int start = from.getOffsetBuffer().getInt((long)fromIndex * 4L);
            int end = from.getOffsetBuffer().getInt((long)(fromIndex + 1) * 4L);
            int length = end - start;
            this.fillHoles(thisIndex);
            BitVectorHelper.setBit(this.validityBuffer, thisIndex);
            int copyStart = this.getStartOffset(thisIndex);
            from.getDataBuffer().getBytes((long)start, this.valueBuffer, (long)copyStart, length);
            this.offsetBuffer.setInt((long)(thisIndex + 1) * 4L, copyStart + length);
        }
        this.lastSet = thisIndex;
    }

    @Override
    public void copyFromSafe(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument((this.getMinorType() == from.getMinorType() ? 1 : 0) != 0);
        if (from.isNull(fromIndex)) {
            this.handleSafe(thisIndex, 0);
            this.fillHoles(thisIndex);
            BitVectorHelper.unsetBit(this.validityBuffer, thisIndex);
            int copyStart = this.getStartOffset(thisIndex);
            this.offsetBuffer.setInt((long)(thisIndex + 1) * 4L, copyStart);
        } else {
            int start = from.getOffsetBuffer().getInt((long)fromIndex * 4L);
            int end = from.getOffsetBuffer().getInt((long)(fromIndex + 1) * 4L);
            int length = end - start;
            this.handleSafe(thisIndex, length);
            this.fillHoles(thisIndex);
            BitVectorHelper.setBit(this.validityBuffer, thisIndex);
            int copyStart = this.getStartOffset(thisIndex);
            from.getDataBuffer().getBytes((long)start, this.valueBuffer, (long)copyStart, length);
            this.offsetBuffer.setInt((long)(thisIndex + 1) * 4L, copyStart + length);
        }
        this.lastSet = thisIndex;
    }

    @Override
    public ArrowBufPointer getDataPointer(int index) {
        return this.getDataPointer(index, new ArrowBufPointer());
    }

    @Override
    public ArrowBufPointer getDataPointer(int index, ArrowBufPointer reuse) {
        if (this.isNull(index)) {
            reuse.set(null, 0L, 0L);
        } else {
            int offset = this.getStartOffset(index);
            int length = this.getEndOffset(index) - offset;
            reuse.set(this.valueBuffer, (long)offset, (long)length);
        }
        return reuse;
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isNull(index)) {
            return 0;
        }
        int start = this.getStartOffset(index);
        int end = this.getEndOffset(index);
        return ByteFunctionHelpers.hash((ArrowBufHasher)hasher, (ArrowBuf)this.getDataBuffer(), (long)start, (long)end);
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    public final int getEndOffset(int index) {
        return this.offsetBuffer.getInt((long)(index + 1) * 4L);
    }
}

