/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.cloud.azure;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.helix.HelixCloudProperty;
import org.apache.helix.HelixException;
import org.apache.helix.api.cloud.CloudInstanceInformationProcessor;
import org.apache.helix.cloud.azure.AzureCloudInstanceInformation;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureCloudInstanceInformationProcessor
implements CloudInstanceInformationProcessor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(AzureCloudInstanceInformationProcessor.class);
    private final CloseableHttpClient _closeableHttpClient;
    private final HelixCloudProperty _helixCloudProperty;
    private static final String COMPUTE = "compute";
    private static final String INSTANCE_NAME = "name";
    private static final String DOMAIN = "platformFaultDomain";
    private static final String INSTANCE_SET_NAME = "vmScaleSetName";

    public AzureCloudInstanceInformationProcessor(HelixCloudProperty helixCloudProperty) {
        this._helixCloudProperty = helixCloudProperty;
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)helixCloudProperty.getCloudRequestTimeout()).setConnectTimeout((int)helixCloudProperty.getCloudConnectionTimeout()).build();
        HttpRequestRetryHandler httpRequestRetryHandler = (exception, executionCount, context) -> {
            LOG.warn("Execution count: " + executionCount + ".", (Throwable)exception);
            return executionCount < helixCloudProperty.getCloudMaxRetry() && !(exception instanceof InterruptedIOException) && !(exception instanceof UnknownHostException) && !(exception instanceof SSLException);
        };
        this._closeableHttpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRetryHandler(httpRequestRetryHandler).build();
    }

    public AzureCloudInstanceInformationProcessor(HelixCloudProperty helixCloudProperty, CloseableHttpClient closeableHttpClient) {
        this._helixCloudProperty = helixCloudProperty;
        this._closeableHttpClient = closeableHttpClient;
    }

    @Override
    public List<String> fetchCloudInstanceInformation() {
        ArrayList<String> response = new ArrayList<String>();
        for (String url : this._helixCloudProperty.getCloudInfoSources()) {
            response.add(this.getAzureCloudInformationFromUrl(url));
        }
        return response;
    }

    private String getAzureCloudInformationFromUrl(String url) {
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader("Metadata", "true");
        try {
            CloseableHttpResponse response = this._closeableHttpClient.execute((HttpUriRequest)httpGet);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                String errorMsg = String.format("Failed to get an HTTP Response for the request. Response: %s. Status code: %s", response == null ? "NULL" : response.getStatusLine().getReasonPhrase(), response.getStatusLine().getStatusCode());
                throw new HelixException(errorMsg);
            }
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.info("VM instance information query result: {}", (Object)responseString);
            return responseString;
        }
        catch (IOException e) {
            throw new HelixException(String.format("Failed to get Azure cloud instance information from url %s", url), e);
        }
    }

    public AzureCloudInstanceInformation parseCloudInstanceInformation(List<String> responses) {
        AzureCloudInstanceInformation azureCloudInstanceInformation = null;
        if (responses.size() > 1) {
            throw new HelixException("Multiple responses are not supported for Azure now");
        }
        String response = responses.get(0);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonNode = mapper.readTree(response);
            JsonNode computeNode = jsonNode.path(COMPUTE);
            if (!computeNode.isMissingNode()) {
                String vmName = computeNode.path(INSTANCE_NAME).textValue();
                String platformFaultDomain = computeNode.path(DOMAIN).textValue();
                String vmssName = computeNode.path(INSTANCE_SET_NAME).textValue();
                String azureTopology = "/faultDomain/hostname";
                String[] parts = azureTopology.trim().split("/");
                String domain = parts[1] + "=" + platformFaultDomain + "," + parts[2] + "=";
                AzureCloudInstanceInformation.Builder builder = new AzureCloudInstanceInformation.Builder();
                builder.setInstanceName(vmName).setFaultDomain(domain).setInstanceSetName(vmssName);
                azureCloudInstanceInformation = builder.build();
            }
        }
        catch (IOException e) {
            throw new HelixException(String.format("Error in parsing cloud instance information: %s", response), e);
        }
        return azureCloudInstanceInformation;
    }
}

