/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.zookeeper.zkclient.util;

import java.util.Random;

public class ExponentialBackoffStrategy {
    private static long INIT_RETRY_INTERVAL = 500L;

    public static long getWaitInterval(long currTime, long maxRetryInterval, boolean addJitter, int numberOfTriesFailed) {
        Random ran = new Random(currTime);
        double exponentialMultiplier = Math.pow(2.0, numberOfTriesFailed - 1);
        double result = exponentialMultiplier * (double)INIT_RETRY_INTERVAL;
        if (maxRetryInterval > 0L && result > (double)maxRetryInterval) {
            result = maxRetryInterval;
        }
        if (addJitter) {
            result *= 0.75 + ran.nextDouble() % 0.25;
        }
        return (long)result;
    }
}

