/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.dataproviders.WorkflowControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.rebalancer.util.RebalanceScheduler;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.TaskUtil;
import org.apache.helix.task.WorkflowConfig;
import org.apache.helix.task.WorkflowContext;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGarbageCollectionStage
extends AbstractAsyncBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(TaskGarbageCollectionStage.class);
    private static RebalanceScheduler _rebalanceScheduler = new RebalanceScheduler();

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.TaskJobPurgeWorker;
    }

    @Override
    public void process(ClusterEvent event) throws Exception {
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            LOG.warn("HelixManager is null for event {}({}) in cluster {}. Skip TaskGarbageCollectionStage.", new Object[]{event.getEventId(), event.getEventType(), event.getClusterName()});
            return;
        }
        HashMap<String, Set<String>> expiredJobsMap = new HashMap<String, Set<String>>();
        HashSet<String> workflowsToBePurged = new HashSet<String>();
        HashSet<String> jobsWithoutConfig = new HashSet<String>();
        WorkflowControllerDataProvider dataProvider = (WorkflowControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        for (Map.Entry<String, ZNRecord> entry : dataProvider.getContexts().entrySet()) {
            WorkflowConfig workflowConfig = dataProvider.getWorkflowConfig(entry.getKey());
            JobConfig jobConfig = dataProvider.getJobConfig(entry.getKey());
            if (workflowConfig != null && (!workflowConfig.isTerminable() || workflowConfig.isJobQueue())) {
                long purgeInterval;
                WorkflowContext workflowContext = dataProvider.getWorkflowContext(entry.getKey());
                if (workflowContext == null || (purgeInterval = workflowConfig.getJobPurgeInterval()) <= 0L) continue;
                long currentTime = System.currentTimeMillis();
                long nextPurgeTime = workflowContext.getLastJobPurgeTime() + purgeInterval;
                if (nextPurgeTime <= currentTime) {
                    nextPurgeTime = currentTime + purgeInterval;
                    Set<String> expiredJobs = TaskUtil.getExpiredJobsFromCache(dataProvider, workflowConfig, workflowContext, manager);
                    if (!expiredJobs.isEmpty()) {
                        expiredJobsMap.put(workflowConfig.getWorkflowId(), expiredJobs);
                    }
                }
                TaskGarbageCollectionStage.scheduleNextJobPurge(workflowConfig.getWorkflowId(), nextPurgeTime, _rebalanceScheduler, manager);
                continue;
            }
            if (workflowConfig == null && entry.getValue() != null && entry.getValue().getId().equals("WorkflowContext")) {
                workflowsToBePurged.add(entry.getKey());
                continue;
            }
            if (jobConfig != null || entry.getValue() == null || !entry.getValue().getId().equals("TaskContext")) continue;
            jobsWithoutConfig.add(entry.getKey());
        }
        event.addAttribute(AttributeName.TO_BE_PURGED_JOBS_MAP.name(), Collections.unmodifiableMap(expiredJobsMap));
        event.addAttribute(AttributeName.TO_BE_PURGED_WORKFLOWS.name(), Collections.unmodifiableSet(workflowsToBePurged));
        event.addAttribute(AttributeName.JOBS_WITHOUT_CONFIG.name(), Collections.unmodifiableSet(jobsWithoutConfig));
        super.process(event);
    }

    @Override
    public void execute(ClusterEvent event) {
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        if (manager == null) {
            LOG.warn("HelixManager is null for event {}({}) in cluster {}. Skip TaskGarbageCollectionStage async execution.", new Object[]{event.getEventId(), event.getEventType(), event.getClusterName()});
            return;
        }
        Map expiredJobsMap = (Map)event.getAttribute(AttributeName.TO_BE_PURGED_JOBS_MAP.name());
        Set toBePurgedWorkflows = (Set)event.getAttribute(AttributeName.TO_BE_PURGED_WORKFLOWS.name());
        Set jobsWithoutConfig = (Set)event.getAttribute(AttributeName.JOBS_WITHOUT_CONFIG.name());
        for (Map.Entry entry : expiredJobsMap.entrySet()) {
            try {
                TaskUtil.purgeExpiredJobs((String)entry.getKey(), (Set)entry.getValue(), manager, _rebalanceScheduler);
            }
            catch (Exception e) {
                LOG.warn("Failed to purge job for workflow {}!", entry.getKey(), (Object)e);
            }
        }
        TaskUtil.workflowGarbageCollection(toBePurgedWorkflows, manager);
        TaskUtil.jobGarbageCollection(jobsWithoutConfig, manager);
    }

    private static void scheduleNextJobPurge(String workflow, long nextPurgeTime, RebalanceScheduler rebalanceScheduler, HelixManager manager) {
        long currentScheduledTime = rebalanceScheduler.getRebalanceTime(workflow);
        if (currentScheduledTime == -1L || currentScheduledTime > nextPurgeTime) {
            rebalanceScheduler.scheduleRebalance(manager, workflow, nextPurgeTime);
        }
    }
}

