/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AutoCreatedLeafQueueConfig;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class QueueManagementChange {
    private final CSQueue queue;
    private AutoCreatedLeafQueueConfig queueTemplateUpdate;
    private final QueueAction queueAction;
    private QueueState transitionToQueueState;

    public QueueManagementChange(CSQueue queue, QueueAction queueAction) {
        this.queue = queue;
        this.queueAction = queueAction;
    }

    public QueueManagementChange(CSQueue queue, QueueAction queueAction, QueueState targetQueueState, AutoCreatedLeafQueueConfig queueTemplateUpdates) {
        this(queue, queueAction, queueTemplateUpdates);
        this.transitionToQueueState = targetQueueState;
    }

    public QueueManagementChange(CSQueue queue, QueueAction queueAction, AutoCreatedLeafQueueConfig queueTemplateUpdates) {
        this(queue, queueAction);
        this.queueTemplateUpdate = queueTemplateUpdates;
    }

    public QueueState getTransitionToQueueState() {
        return this.transitionToQueueState;
    }

    public CSQueue getQueue() {
        return this.queue;
    }

    public AutoCreatedLeafQueueConfig getUpdatedQueueTemplate() {
        return this.queueTemplateUpdate;
    }

    public QueueAction getQueueAction() {
        return this.queueAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueueManagementChange)) {
            return false;
        }
        QueueManagementChange that = (QueueManagementChange)o;
        if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) {
            return false;
        }
        if (this.queueTemplateUpdate != null ? !this.queueTemplateUpdate.equals(that.queueTemplateUpdate) : that.queueTemplateUpdate != null) {
            return false;
        }
        if (this.queueAction != that.queueAction) {
            return false;
        }
        return this.transitionToQueueState == that.transitionToQueueState;
    }

    public int hashCode() {
        int result = this.queue != null ? this.queue.hashCode() : 0;
        result = 31 * result + (this.queueTemplateUpdate != null ? this.queueTemplateUpdate.hashCode() : 0);
        result = 31 * result + (this.queueAction != null ? this.queueAction.hashCode() : 0);
        result = 31 * result + (this.transitionToQueueState != null ? this.transitionToQueueState.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QueueManagementChange{queue=" + this.queue.getQueuePath() + ", updatedEntitlementsByPartition=" + this.queueTemplateUpdate + ", queueAction=" + (Object)((Object)this.queueAction) + ", transitionToQueueState=" + this.transitionToQueueState + '}';
    }

    public static class UpdateQueue
    extends QueueManagementChange {
        public UpdateQueue(CSQueue queue, QueueState targetQueueState, AutoCreatedLeafQueueConfig queueTemplateUpdate) {
            super(queue, QueueAction.UPDATE_QUEUE, targetQueueState, queueTemplateUpdate);
        }

        public UpdateQueue(CSQueue queue, AutoCreatedLeafQueueConfig queueTemplateUpdate) {
            super(queue, QueueAction.UPDATE_QUEUE, queueTemplateUpdate);
        }
    }

    public static enum QueueAction {
        UPDATE_QUEUE;

    }
}

