/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.request;

import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.s3.analyticsaccelerator.request.GetRequest;
import software.amazon.s3.analyticsaccelerator.request.HeadRequest;
import software.amazon.s3.analyticsaccelerator.request.UserAgent;
import software.amazon.s3.analyticsaccelerator.util.ObjectClientUtil;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;

public class RequestFactory {
    private final UserAgent userAgent;

    public RequestFactory(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public HeadObjectRequest.Builder buildHeadObjectRequest(HeadRequest headRequest, OpenStreamInformation openStreamInformation) {
        HeadObjectRequest.Builder builder = HeadObjectRequest.builder().bucket(headRequest.getS3Uri().getBucket()).key(headRequest.getS3Uri().getKey());
        AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder = AwsRequestOverrideConfiguration.builder();
        requestOverrideConfigurationBuilder.putHeader("User-Agent", this.userAgent.getUserAgent());
        if (openStreamInformation.getStreamAuditContext() != null) {
            ObjectClientUtil.attachStreamContextToExecutionAttributes(requestOverrideConfigurationBuilder, openStreamInformation.getStreamAuditContext());
        }
        builder.overrideConfiguration(requestOverrideConfigurationBuilder.build());
        if (openStreamInformation.getEncryptionSecrets() != null && openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().isPresent()) {
            String customerKey = openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().get();
            String customerKeyMd5 = openStreamInformation.getEncryptionSecrets().getSsecCustomerKeyMd5();
            builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(customerKey).sseCustomerKeyMD5(customerKeyMd5);
        }
        return builder;
    }

    public GetObjectRequest.Builder getObjectRequest(GetRequest getRequest, OpenStreamInformation openStreamInformation) {
        GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(getRequest.getS3Uri().getBucket()).ifMatch(getRequest.getEtag()).key(getRequest.getS3Uri().getKey());
        String range = getRequest.getRange().toHttpString();
        builder.range(range);
        AwsRequestOverrideConfiguration.Builder requestOverrideConfigurationBuilder = (AwsRequestOverrideConfiguration.Builder)((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().putHeader("Referer", getRequest.getReferrer().toString())).putHeader("User-Agent", this.userAgent.getUserAgent());
        if (openStreamInformation.getStreamAuditContext() != null) {
            ObjectClientUtil.attachStreamContextToExecutionAttributes(requestOverrideConfigurationBuilder, openStreamInformation.getStreamAuditContext());
        }
        builder.overrideConfiguration(requestOverrideConfigurationBuilder.build());
        if (openStreamInformation.getEncryptionSecrets() != null && openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().isPresent()) {
            String customerKey = openStreamInformation.getEncryptionSecrets().getSsecCustomerKey().get();
            String customerKeyMd5 = openStreamInformation.getEncryptionSecrets().getSsecCustomerKeyMd5();
            builder.sseCustomerAlgorithm(ServerSideEncryption.AES256.name()).sseCustomerKey(customerKey).sseCustomerKeyMD5(customerKeyMd5);
        }
        return builder;
    }
}

