/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.namenode.AuditLogger;
import org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.LeaseManager;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.ha.HAContext;
import org.apache.hadoop.hdfs.server.namenode.ha.HAState;
import org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.test.Whitebox;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestFSNamesystem {
    @After
    public void cleanUp() {
        FileUtil.fullyDeleteContents((File)new File(MiniDFSCluster.getBaseDirectory()));
    }

    @Test
    public void testUniqueEditDirs() throws IOException {
        Configuration config = new Configuration();
        config.set("dfs.namenode.edits.dir", "file://edits/dir, file://edits/dir1,file://edits/dir1");
        List editsDirs = FSNamesystem.getNamespaceEditsDirs((Configuration)config);
        Assert.assertEquals((long)2L, (long)editsDirs.size());
    }

    @Test
    public void testFSNamespaceClearLeases() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        File nameDir = new File(MiniDFSCluster.getBaseDirectory(), "name");
        conf.set("dfs.namenode.name.dir", nameDir.getAbsolutePath());
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        DFSTestUtil.formatNameNode((Configuration)conf);
        FSNamesystem fsn = FSNamesystem.loadFromDisk((Configuration)conf);
        LeaseManager leaseMan = fsn.getLeaseManager();
        leaseMan.addLease("client1", fsn.getFSDirectory().allocateNewInodeId());
        Assert.assertEquals((long)1L, (long)leaseMan.countLease());
        this.clearNamesystem(fsn);
        leaseMan = fsn.getLeaseManager();
        Assert.assertEquals((long)0L, (long)leaseMan.countLease());
    }

    @Test
    public void testStartupSafemode() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.leaveSafeMode(false);
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After leaving safemode FSNamesystem.isInSafeMode still returned true", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        fsn.enterSafeMode(true);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInStartupSafeMode still returned true", (!fsn.isInStartupSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"After entering safemode due to low resources FSNamesystem.isInSafeMode still returned false", (boolean)fsn.isInSafeMode());
    }

    @Test
    public void testReplQueuesActiveAfterStartupSafemode() throws IOException, InterruptedException {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsNamesystem = new FSNamesystem(conf, fsImage);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        BlockManager bm = fsn.getBlockManager();
        Whitebox.setInternalState((Object)bm, (String)"namesystem", (Object)fsn);
        HAContext haContext = (HAContext)Mockito.mock(HAContext.class);
        HAState haState = (HAState)Mockito.mock(HAState.class);
        Mockito.when((Object)haContext.getState()).thenReturn((Object)haState);
        Mockito.when((Object)haState.shouldPopulateReplQueues()).thenReturn((Object)true);
        Mockito.when((Object)fsn.getHAContext()).thenReturn((Object)haContext);
        NameNode.initMetrics((Configuration)conf, (HdfsServerConstants.NamenodeRole)HdfsServerConstants.NamenodeRole.NAMENODE);
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues were being populated during very first safemode", (!bm.isPopulatingReplQueues() ? 1 : 0) != 0);
        fsn.leaveSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't leave safemode", (!fsn.isInSafeMode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Replication queues weren't being populated even after leaving safemode", (boolean)bm.isPopulatingReplQueues());
        fsn.enterSafeMode(false);
        Assert.assertTrue((String)"FSNamesystem didn't enter safemode", (boolean)fsn.isInSafeMode());
        Assert.assertTrue((String)"Replication queues weren't being populated after entering safemode 2nd time", (boolean)bm.isPopulatingReplQueues());
    }

    @Test
    public void testHAStateInNamespaceInfo() throws IOException {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        NNStorage nnStorage = (NNStorage)Mockito.mock(NNStorage.class);
        Mockito.when((Object)fsImage.getStorage()).thenReturn((Object)nnStorage);
        FSNamesystem fsNamesystem = new FSNamesystem(conf, fsImage);
        FSNamesystem fsn = (FSNamesystem)Mockito.spy((Object)fsNamesystem);
        Mockito.when((Object)fsn.getState()).thenReturn((Object)HAServiceProtocol.HAServiceState.ACTIVE);
        NamespaceInfo nsInfo = fsn.unprotectedGetNamespaceInfo();
        Assert.assertNotNull((Object)nsInfo.getState());
    }

    @Test
    public void testReset() throws Exception {
        Configuration conf = new Configuration();
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        fsn.imageLoadComplete();
        Assert.assertTrue((boolean)fsn.isImageLoaded());
        this.clearNamesystem(fsn);
        INodeDirectory root = (INodeDirectory)fsn.getFSDirectory().getINode("/");
        Assert.assertTrue((boolean)root.getChildrenList(0x7FFFFFFE).isEmpty());
        fsn.imageLoadComplete();
        Assert.assertTrue((boolean)fsn.isImageLoaded());
    }

    private void clearNamesystem(FSNamesystem fsn) {
        fsn.writeLock();
        try {
            fsn.clear();
            Assert.assertFalse((boolean)fsn.isImageLoaded());
        }
        finally {
            fsn.writeUnlock();
        }
    }

    @Test
    public void testGetEffectiveLayoutVersion() {
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-60, (int)-61, (int)-63));
        Assert.assertEquals((long)-61L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-61, (int)-61, (int)-63));
        Assert.assertEquals((long)-62L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-62, (int)-61, (int)-63));
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)true, (int)-63, (int)-61, (int)-63));
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-60, (int)-61, (int)-63));
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-61, (int)-61, (int)-63));
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-62, (int)-61, (int)-63));
        Assert.assertEquals((long)-63L, (long)FSNamesystem.getEffectiveLayoutVersion((boolean)false, (int)-63, (int)-61, (int)-63));
    }

    @Test
    public void testSafemodeReplicationConf() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        conf.setInt("dfs.namenode.replication.min", 2);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        Object bmSafeMode = Whitebox.getInternalState((Object)fsn.getBlockManager(), (String)"bmSafeMode");
        int safeReplication = (Integer)Whitebox.getInternalState((Object)bmSafeMode, (String)"safeReplication");
        Assert.assertEquals((long)2L, (long)safeReplication);
    }

    @Test(timeout=30000L)
    public void testInitAuditLoggers() throws IOException {
        Configuration conf = new Configuration();
        FSImage fsImage = (FSImage)Mockito.mock(FSImage.class);
        FSEditLog fsEditLog = (FSEditLog)Mockito.mock(FSEditLog.class);
        Mockito.when((Object)fsImage.getEditLog()).thenReturn((Object)fsEditLog);
        conf.set("dfs.namenode.audit.loggers", "");
        conf.setBoolean("dfs.namenode.top.enabled", false);
        conf.setBoolean("hadoop.caller.context.enabled", true);
        FSNamesystem fsn = new FSNamesystem(conf, fsImage);
        List auditLoggers = fsn.getAuditLoggers();
        Assert.assertTrue((auditLoggers.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(auditLoggers.get(0) instanceof FSNamesystem.FSNamesystemAuditLogger));
        FSNamesystem.FSNamesystemAuditLogger defaultAuditLogger = (FSNamesystem.FSNamesystemAuditLogger)auditLoggers.get(0);
        Assert.assertTrue((boolean)defaultAuditLogger.getCallerContextEnabled());
        conf.set("dfs.namenode.audit.loggers", "");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        Assert.assertTrue((auditLoggers.size() == 2 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assert.assertThat((Object)auditLogger, (Matcher)CoreMatchers.either((Matcher)CoreMatchers.instanceOf(FSNamesystem.FSNamesystemAuditLogger.class)).or(CoreMatchers.instanceOf(TopAuditLogger.class)));
        }
        conf.set("dfs.namenode.audit.loggers", "default");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        Assert.assertTrue((auditLoggers.size() == 2 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assert.assertThat((Object)auditLogger, (Matcher)CoreMatchers.either((Matcher)CoreMatchers.instanceOf(FSNamesystem.FSNamesystemAuditLogger.class)).or(CoreMatchers.instanceOf(TopAuditLogger.class)));
        }
        conf.set("dfs.namenode.audit.loggers", " default, org.apache.hadoop.hdfs.server.namenode.TestFSNamesystem$DummyAuditLogger  ");
        conf.setBoolean("dfs.namenode.top.enabled", true);
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        Assert.assertTrue((auditLoggers.size() == 3 ? 1 : 0) != 0);
        for (AuditLogger auditLogger : auditLoggers) {
            Assert.assertThat((Object)auditLogger, (Matcher)CoreMatchers.either((Matcher)CoreMatchers.instanceOf(FSNamesystem.FSNamesystemAuditLogger.class)).or(CoreMatchers.instanceOf(TopAuditLogger.class)).or(CoreMatchers.instanceOf(DummyAuditLogger.class)));
        }
        conf.set("dfs.namenode.audit.loggers", "org.apache.hadoop.hdfs.server.namenode.top.TopAuditLogger");
        fsn = new FSNamesystem(conf, fsImage);
        auditLoggers = fsn.getAuditLoggers();
        Assert.assertEquals((long)1L, (long)auditLoggers.size());
        Assert.assertThat(auditLoggers.get(0), (Matcher)CoreMatchers.instanceOf(TopAuditLogger.class));
    }

    static class DummyAuditLogger
    implements AuditLogger {
        DummyAuditLogger() {
        }

        public void initialize(Configuration conf) {
        }

        public void logAuditEvent(boolean succeeded, String userName, InetAddress addr, String cmd, String src, String dst, FileStatus stat) {
        }
    }
}

