/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.Constants;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.auth.SignerFactory;
import org.apache.hadoop.fs.s3a.impl.ConfigurationHelper;
import org.apache.hadoop.fs.s3a.impl.NetworkBinding;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.ProxyConfiguration;

public final class AWSClientConfig {
    private static final Logger LOG = LoggerFactory.getLogger(AWSClientConfig.class);
    private static Duration minimumOperationDuration = Constants.MINIMUM_NETWORK_OPERATION_DURATION;

    private AWSClientConfig() {
    }

    public static ClientOverrideConfiguration.Builder createClientConfigBuilder(Configuration conf, String awsServiceIdentifier) throws IOException {
        ClientOverrideConfiguration.Builder overrideConfigBuilder = ClientOverrideConfiguration.builder();
        AWSClientConfig.initRequestTimeout(conf, overrideConfigBuilder);
        AWSClientConfig.initUserAgent(conf, overrideConfigBuilder);
        String signer = conf.getTrimmed("fs.s3a.signing-algorithm", "");
        if (!signer.isEmpty()) {
            LOG.debug("Signer override = {}", (Object)signer);
            overrideConfigBuilder.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)SignerFactory.createSigner(signer, conf, "fs.s3a.signing-algorithm"));
        }
        AWSClientConfig.initSigner(conf, overrideConfigBuilder, awsServiceIdentifier);
        return overrideConfigBuilder;
    }

    public static ApacheHttpClient.Builder createHttpClientBuilder(Configuration conf) throws IOException {
        ConnectionSettings conn = AWSClientConfig.createConnectionSettings(conf);
        ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder().connectionAcquisitionTimeout(conn.getAcquisitionTimeout()).connectionMaxIdleTime(conn.getMaxIdleTime()).connectionTimeout(conn.getEstablishTimeout()).connectionTimeToLive(conn.getConnectionTTL()).expectContinueEnabled(Boolean.valueOf(conn.isExpectContinueEnabled())).maxConnections(Integer.valueOf(conn.getMaxConnections())).socketTimeout(conn.getSocketTimeout()).tcpKeepAlive(Boolean.valueOf(conn.isKeepAlive())).useIdleConnectionReaper(Boolean.valueOf(true));
        NetworkBinding.bindSSLChannelMode(conf, httpClientBuilder);
        return httpClientBuilder;
    }

    public static NettyNioAsyncHttpClient.Builder createAsyncHttpClientBuilder(Configuration conf) {
        ConnectionSettings conn = AWSClientConfig.createConnectionSettings(conf);
        NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder().connectionAcquisitionTimeout(conn.getAcquisitionTimeout()).connectionMaxIdleTime(conn.getMaxIdleTime()).connectionTimeout(conn.getEstablishTimeout()).connectionTimeToLive(conn.getConnectionTTL()).maxConcurrency(Integer.valueOf(conn.getMaxConnections())).readTimeout(conn.getSocketTimeout()).tcpKeepAlive(Boolean.valueOf(conn.isKeepAlive())).useIdleConnectionReaper(Boolean.valueOf(true)).writeTimeout(conn.getSocketTimeout());
        return httpClientBuilder;
    }

    public static RetryPolicy.Builder createRetryPolicyBuilder(Configuration conf) {
        RetryPolicy.Builder retryPolicyBuilder = RetryPolicy.builder((RetryMode)RetryMode.ADAPTIVE);
        retryPolicyBuilder.numRetries(Integer.valueOf(S3AUtils.intOption(conf, "fs.s3a.attempts.maximum", 5, 0)));
        return retryPolicyBuilder;
    }

    public static ProxyConfiguration createProxyConfiguration(Configuration conf, String bucket) throws IOException {
        ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder();
        String proxyHost = conf.getTrimmed("fs.s3a.proxy.host", "");
        int proxyPort = conf.getInt("fs.s3a.proxy.port", -1);
        if (!proxyHost.isEmpty()) {
            if (proxyPort >= 0) {
                String scheme = conf.getBoolean("fs.s3a.proxy.ssl.enabled", false) ? "https" : "http";
                proxyConfigBuilder.endpoint(AWSClientConfig.buildURI(scheme, proxyHost, proxyPort));
            } else if (conf.getBoolean("fs.s3a.proxy.ssl.enabled", false)) {
                LOG.warn("Proxy host set without port. Using HTTPS default 443");
                proxyConfigBuilder.endpoint(AWSClientConfig.buildURI("https", proxyHost, 443));
            } else {
                LOG.warn("Proxy host set without port. Using HTTP default 80");
                proxyConfigBuilder.endpoint(AWSClientConfig.buildURI("http", proxyHost, 80));
            }
            String proxyUsername = S3AUtils.lookupPassword(bucket, conf, "fs.s3a.proxy.username", null, null);
            String proxyPassword = S3AUtils.lookupPassword(bucket, conf, "fs.s3a.proxy.password", null, null);
            if (proxyUsername == null != (proxyPassword == null)) {
                String msg = "Proxy error: fs.s3a.proxy.username or fs.s3a.proxy.password set without the other.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            proxyConfigBuilder.username(proxyUsername);
            proxyConfigBuilder.password(proxyPassword);
            proxyConfigBuilder.ntlmDomain(conf.getTrimmed("fs.s3a.proxy.domain"));
            proxyConfigBuilder.ntlmWorkstation(conf.getTrimmed("fs.s3a.proxy.workstation"));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using proxy server {}:{} as user {} with password {} on domain {} as workstation {}", new Object[]{proxyHost, proxyPort, proxyUsername, proxyPassword, "fs.s3a.proxy.domain", "fs.s3a.proxy.workstation"});
            }
        } else if (proxyPort >= 0) {
            String msg = "Proxy error: fs.s3a.proxy.port set without fs.s3a.proxy.host";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return (ProxyConfiguration)proxyConfigBuilder.build();
    }

    public static software.amazon.awssdk.http.nio.netty.ProxyConfiguration createAsyncProxyConfiguration(Configuration conf, String bucket) throws IOException {
        ProxyConfiguration.Builder proxyConfigBuilder = software.amazon.awssdk.http.nio.netty.ProxyConfiguration.builder();
        String proxyHost = conf.getTrimmed("fs.s3a.proxy.host", "");
        int proxyPort = conf.getInt("fs.s3a.proxy.port", -1);
        if (!proxyHost.isEmpty()) {
            if (proxyPort >= 0) {
                String scheme = conf.getBoolean("fs.s3a.proxy.ssl.enabled", false) ? "https" : "http";
                proxyConfigBuilder.host(proxyHost);
                proxyConfigBuilder.port(proxyPort);
                proxyConfigBuilder.scheme(scheme);
            } else if (conf.getBoolean("fs.s3a.proxy.ssl.enabled", false)) {
                LOG.warn("Proxy host set without port. Using HTTPS default 443");
                proxyConfigBuilder.host(proxyHost);
                proxyConfigBuilder.port(443);
                proxyConfigBuilder.scheme("https");
            } else {
                LOG.warn("Proxy host set without port. Using HTTP default 80");
                proxyConfigBuilder.host(proxyHost);
                proxyConfigBuilder.port(80);
                proxyConfigBuilder.scheme("http");
            }
            String proxyUsername = S3AUtils.lookupPassword(bucket, conf, "fs.s3a.proxy.username", null, null);
            String proxyPassword = S3AUtils.lookupPassword(bucket, conf, "fs.s3a.proxy.password", null, null);
            if (proxyUsername == null != (proxyPassword == null)) {
                String msg = "Proxy error: fs.s3a.proxy.username or fs.s3a.proxy.password set without the other.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            proxyConfigBuilder.username(proxyUsername);
            proxyConfigBuilder.password(proxyPassword);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using proxy server {}:{} as user {} with password {} on domain {} as workstation {}", new Object[]{proxyHost, proxyPort, proxyUsername, proxyPassword, "fs.s3a.proxy.domain", "fs.s3a.proxy.workstation"});
            }
        } else {
            if (proxyPort >= 0) {
                String msg = "Proxy error: fs.s3a.proxy.port set without fs.s3a.proxy.host";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            return null;
        }
        return (software.amazon.awssdk.http.nio.netty.ProxyConfiguration)proxyConfigBuilder.build();
    }

    private static URI buildURI(String scheme, String host, int port) {
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            String msg = "Proxy error: incorrect fs.s3a.proxy.host or fs.s3a.proxy.port";
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
    }

    private static void initUserAgent(Configuration conf, ClientOverrideConfiguration.Builder clientConfig) {
        String userAgent = "Hadoop " + VersionInfo.getVersion();
        String userAgentPrefix = conf.getTrimmed("fs.s3a.user.agent.prefix", "");
        if (!userAgentPrefix.isEmpty()) {
            userAgent = userAgentPrefix + ", " + userAgent;
        }
        LOG.debug("Using User-Agent: {}", (Object)userAgent);
        clientConfig.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)userAgent);
    }

    private static void initSigner(Configuration conf, ClientOverrideConfiguration.Builder clientConfig, String awsServiceIdentifier) throws IOException {
        String signerOverride;
        String configKey = null;
        switch (awsServiceIdentifier) {
            case "S3": {
                configKey = Constants.SIGNING_ALGORITHM_S3;
                break;
            }
            case "STS": {
                configKey = Constants.SIGNING_ALGORITHM_STS;
                break;
            }
        }
        if (configKey != null && !(signerOverride = conf.getTrimmed(configKey, "")).isEmpty()) {
            LOG.debug("Signer override for {} = {}", (Object)awsServiceIdentifier, (Object)signerOverride);
            clientConfig.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)SignerFactory.createSigner(signerOverride, conf, configKey));
        }
    }

    private static void initRequestTimeout(Configuration conf, ClientOverrideConfiguration.Builder clientConfig) {
        Duration callTimeout = AWSClientConfig.createApiConnectionSettings(conf).getApiCallTimeout();
        if (callTimeout.toMillis() > 0L) {
            clientConfig.apiCallAttemptTimeout(callTimeout);
            clientConfig.apiCallTimeout(callTimeout);
        }
    }

    @VisibleForTesting
    public static void resetMinimumOperationDuration() {
        AWSClientConfig.setMinimumOperationDuration(Constants.MINIMUM_NETWORK_OPERATION_DURATION);
    }

    @VisibleForTesting
    public static void setMinimumOperationDuration(Duration duration) {
        LOG.info("Setting minimum operation duration to {}ms", (Object)duration.toMillis());
        Preconditions.checkArgument((duration.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (String)"Duration must be positive: %sms", (Object[])new Object[]{duration.toMillis()});
        minimumOperationDuration = duration;
    }

    public static Duration getMinimumOperationDuration() {
        return minimumOperationDuration;
    }

    static ClientSettings createApiConnectionSettings(Configuration conf) {
        Duration apiCallTimeout = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.request.timeout", Constants.DEFAULT_REQUEST_TIMEOUT_DURATION, TimeUnit.MILLISECONDS, Duration.ZERO);
        if (apiCallTimeout.compareTo(Duration.ZERO) > 0) {
            apiCallTimeout = ConfigurationHelper.enforceMinimumDuration("fs.s3a.connection.request.timeout", apiCallTimeout, minimumOperationDuration);
        }
        return new ClientSettings(apiCallTimeout);
    }

    static ConnectionSettings createConnectionSettings(Configuration conf) {
        int maxConnections = S3AUtils.intOption(conf, "fs.s3a.connection.maximum", 500, 1);
        boolean keepAlive = conf.getBoolean("fs.s3a.connection.keepalive", false);
        Duration acquisitionTimeout = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.acquisition.timeout", Constants.DEFAULT_CONNECTION_ACQUISITION_TIMEOUT_DURATION, TimeUnit.MILLISECONDS, minimumOperationDuration);
        Duration connectionTTL = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.ttl", Constants.DEFAULT_CONNECTION_TTL_DURATION, TimeUnit.MILLISECONDS, null);
        Duration establishTimeout = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.establish.timeout", Constants.DEFAULT_ESTABLISH_TIMEOUT_DURATION, TimeUnit.MILLISECONDS, minimumOperationDuration);
        Duration maxIdleTime = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.idle.time", Constants.DEFAULT_CONNECTION_IDLE_TIME_DURATION, TimeUnit.MILLISECONDS, Duration.ZERO);
        Duration socketTimeout = ConfigurationHelper.getDuration(conf, "fs.s3a.connection.timeout", Constants.DEFAULT_SOCKET_TIMEOUT_DURATION, TimeUnit.MILLISECONDS, minimumOperationDuration);
        boolean expectContinueEnabled = conf.getBoolean("fs.s3a.connection.expect.continue", true);
        return new ConnectionSettings(maxConnections, keepAlive, acquisitionTimeout, connectionTTL, establishTimeout, maxIdleTime, socketTimeout, expectContinueEnabled);
    }

    public static void setRequestTimeout(AwsRequest.Builder builder, Duration timeout) {
        if (!timeout.isZero()) {
            builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().apiCallTimeout(timeout)).apiCallAttemptTimeout(timeout)).build());
        }
    }

    static final class ConnectionSettings {
        private final int maxConnections;
        private final boolean keepAlive;
        private final Duration acquisitionTimeout;
        private final Duration connectionTTL;
        private final Duration establishTimeout;
        private final Duration maxIdleTime;
        private final Duration socketTimeout;
        private final boolean expectContinueEnabled;

        private ConnectionSettings(int maxConnections, boolean keepAlive, Duration acquisitionTimeout, Duration connectionTTL, Duration establishTimeout, Duration maxIdleTime, Duration socketTimeout, boolean expectContinueEnabled) {
            this.maxConnections = maxConnections;
            this.keepAlive = keepAlive;
            this.acquisitionTimeout = acquisitionTimeout;
            this.connectionTTL = connectionTTL;
            this.establishTimeout = establishTimeout;
            this.maxIdleTime = maxIdleTime;
            this.socketTimeout = socketTimeout;
            this.expectContinueEnabled = expectContinueEnabled;
        }

        int getMaxConnections() {
            return this.maxConnections;
        }

        boolean isKeepAlive() {
            return this.keepAlive;
        }

        Duration getAcquisitionTimeout() {
            return this.acquisitionTimeout;
        }

        Duration getConnectionTTL() {
            return this.connectionTTL;
        }

        Duration getEstablishTimeout() {
            return this.establishTimeout;
        }

        Duration getMaxIdleTime() {
            return this.maxIdleTime;
        }

        Duration getSocketTimeout() {
            return this.socketTimeout;
        }

        boolean isExpectContinueEnabled() {
            return this.expectContinueEnabled;
        }

        public String toString() {
            return "ConnectionSettings{maxConnections=" + this.maxConnections + ", keepAlive=" + this.keepAlive + ", acquisitionTimeout=" + this.acquisitionTimeout + ", connectionTTL=" + this.connectionTTL + ", establishTimeout=" + this.establishTimeout + ", maxIdleTime=" + this.maxIdleTime + ", socketTimeout=" + this.socketTimeout + ", expectContinueEnabled=" + this.expectContinueEnabled + '}';
        }
    }

    static class ClientSettings {
        private final Duration apiCallTimeout;

        private ClientSettings(Duration apiCallTimeout) {
            this.apiCallTimeout = apiCallTimeout;
        }

        Duration getApiCallTimeout() {
            return this.apiCallTimeout;
        }

        public String toString() {
            return "ClientSettings{apiCallTimeout=" + this.apiCallTimeout + '}';
        }
    }
}

