/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.apache.hadoop.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.Aws4UnsignedPayloadSigner;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.core.signer.NoOpSigner;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;

public final class SignerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SignerFactory.class);
    public static final String VERSION_FOUR_SIGNER = "AWS4SignerType";
    public static final String VERSION_FOUR_UNSIGNED_PAYLOAD_SIGNER = "AWS4UnsignedPayloadSignerType";
    public static final String NO_OP_SIGNER = "NoOpSignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    public static final String S3_V2_SIGNER = "S3SignerType";
    private static final Map<String, Class<? extends Signer>> SIGNERS = new ConcurrentHashMap<String, Class<? extends Signer>>();

    private SignerFactory() {
    }

    public static void registerSigner(String signerType, Class<? extends Signer> signerClass) {
        Preconditions.checkArgument((signerType != null ? 1 : 0) != 0, (Object)"signerType cannot be null");
        Preconditions.checkArgument((signerClass != null ? 1 : 0) != 0, (Object)"signerClass cannot be null");
        SIGNERS.put(signerType, signerClass);
    }

    public static boolean isSignerRegistered(String signerType) {
        return SIGNERS.containsKey(signerType);
    }

    public static Signer createSigner(String signerType, Configuration conf, String configKey) throws IOException {
        if (S3_V2_SIGNER.equals(signerType)) {
            throw InstantiationIOException.unavailable(null, null, configKey, "S3SignerType is no longer supported");
        }
        if (!SignerFactory.isSignerRegistered(signerType)) {
            throw InstantiationIOException.unavailable(null, null, configKey, "unknown signer type: " + signerType);
        }
        Class<? extends Signer> signerClass = SIGNERS.get(signerType);
        String className = signerClass.getName();
        LOG.debug("Signer class from {} and key {} is {}", new Object[]{signerType, configKey, className});
        Signer signer = S3AUtils.getInstanceFromReflection(className, null, null, Signer.class, "create", configKey);
        Objects.requireNonNull(conf);
        if (signer instanceof Configurable) {
            ((Configurable)signer).setConf(conf);
        }
        return signer;
    }

    public static AuthScheme<AwsCredentialsIdentity> createAuthScheme(final String schemeId, final HttpSigner<AwsCredentialsIdentity> signer) {
        return new AuthScheme<AwsCredentialsIdentity>(){

            public String schemeId() {
                return schemeId;
            }

            public IdentityProvider<AwsCredentialsIdentity> identityProvider(IdentityProviders providers) {
                return providers.identityProvider(AwsCredentialsIdentity.class);
            }

            public HttpSigner<AwsCredentialsIdentity> signer() {
                return signer;
            }
        };
    }

    public static AuthScheme<AwsCredentialsIdentity> createHttpSigner(Configuration conf, String scheme, String configKey) throws IOException {
        Class clazz = conf.getClass("fs.s3a.http.signer.class", null, HttpSigner.class);
        Preconditions.checkState((clazz != null ? 1 : 0) != 0, (String)"No http signer class defined in %s", (Object[])new Object[]{configKey});
        LOG.debug("Creating http signer {} from {}", (Object)clazz, (Object)configKey);
        try {
            return SignerFactory.createAuthScheme(scheme, (HttpSigner<AwsCredentialsIdentity>)((HttpSigner)clazz.newInstance()));
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new InstantiationIOException(InstantiationIOException.Kind.InstantiationFailure, null, clazz.getName(), "fs.s3a.http.signer.class", e.toString(), e);
        }
    }

    static {
        SIGNERS.put(VERSION_FOUR_SIGNER, Aws4Signer.class);
        SIGNERS.put(VERSION_FOUR_UNSIGNED_PAYLOAD_SIGNER, Aws4UnsignedPayloadSigner.class);
        SIGNERS.put(NO_OP_SIGNER, NoOpSigner.class);
        SIGNERS.put(S3_V4_SIGNER, AwsS3V4Signer.class);
    }
}

