/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.LogInfo;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DomainLogInfo
extends LogInfo {
    private static final Logger LOG = LoggerFactory.getLogger(EntityGroupFSTimelineStore.class);

    public DomainLogInfo(String attemptDirName, String file, String owner) {
        super(attemptDirName, file, owner);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected long doParse(TimelineDataManager tdm, JsonParser parser, ObjectMapper objMapper, UserGroupInformation ugi, boolean appCompleted) throws IOException {
        long count = 0L;
        boolean putError = false;
        try {
            MappingIterator iter = objMapper.readValues(parser, TimelineDomain.class);
            while (iter.hasNext()) {
                TimelineDomain domain = (TimelineDomain)iter.next();
                domain.setOwner(ugi.getShortUserName());
                LOG.trace("Read domain {}", (Object)domain.getId());
                ++count;
                long curPos = ((FSDataInputStream)parser.getInputSource()).getPos();
                LOG.debug("Parser now at offset {}", (Object)curPos);
                try {
                    tdm.putDomain(domain, ugi);
                    this.setOffset(curPos);
                }
                catch (YarnException e) {
                    putError = true;
                    throw new IOException("Error posting domain", e);
                }
                catch (IOException e) {
                    putError = true;
                    throw new IOException("Error posting domain", e);
                    return count;
                }
            }
        }
        catch (IOException e) {
            if (!appCompleted && !putError) return count;
            throw e;
        }
        catch (RuntimeException e) {
            if (!appCompleted && e.getCause() instanceof JsonParseException) return count;
            throw e;
        }
    }
}

