/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.planner;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.apache.hadoop.hdfs.server.diskbalancer.datamodel.DiskBalancerVolume;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.MoveStep;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.NodePlan;
import org.apache.hadoop.hdfs.server.diskbalancer.planner.Step;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.SampleStep;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TestNodePlan {
    @Test
    public void testNodePlan() throws IOException {
        NodePlan nodePlan = new NodePlan("datanode1234", 1234);
        MoveStep moveStep = new MoveStep();
        moveStep.setBandwidth(12345L);
        moveStep.setBytesToMove(98765L);
        moveStep.setIdealStorage(1.234);
        moveStep.setMaxDiskErrors(4567L);
        moveStep.setVolumeSetID("id1234");
        nodePlan.addStep((Step)moveStep);
        String json = nodePlan.toJson();
        Assertions.assertThat((Object)NodePlan.parseJson((String)json)).isNotNull();
    }

    @Test
    public void testNodePlanWithDisallowedStep() throws Exception {
        NodePlan nodePlan = new NodePlan("datanode1234", 1234);
        SampleStep sampleStep = new SampleStep();
        sampleStep.setBandwidth(12345L);
        sampleStep.setMaxDiskErrors(4567L);
        nodePlan.addStep((Step)sampleStep);
        this.assertNodePlanInvalid(nodePlan);
    }

    @Test
    public void testNodePlanWithSecondStepDisallowed() throws Exception {
        NodePlan nodePlan = new NodePlan("datanode1234", 1234);
        MoveStep moveStep = new MoveStep();
        moveStep.setBandwidth(12345L);
        moveStep.setBytesToMove(98765L);
        moveStep.setIdealStorage(1.234);
        moveStep.setMaxDiskErrors(4567L);
        moveStep.setVolumeSetID("id1234");
        nodePlan.addStep((Step)moveStep);
        SampleStep sampleStep = new SampleStep();
        sampleStep.setBandwidth(12345L);
        sampleStep.setMaxDiskErrors(4567L);
        nodePlan.addStep((Step)sampleStep);
        this.assertNodePlanInvalid(nodePlan);
    }

    @Test
    public void testNodePlanWithNestedDisallowedStep() throws Exception {
        NodePlan nodePlan = new NodePlan("datanode1234", 1234);
        NodePlan nodePlan2 = new NodePlan("datanode9876", 9876);
        SampleStep sampleStep = new SampleStep();
        sampleStep.setBandwidth(12345L);
        sampleStep.setMaxDiskErrors(4567L);
        nodePlan2.addStep((Step)sampleStep);
        NestedStep nestedStep = new NestedStep(nodePlan2);
        nestedStep.setBandwidth(1234L);
        nestedStep.setMaxDiskErrors(456L);
        nodePlan.addStep((Step)nestedStep);
        this.assertNodePlanInvalid(nodePlan);
    }

    private void assertNodePlanInvalid(NodePlan nodePlan) throws Exception {
        LambdaTestUtils.intercept(IOException.class, (String)"Invalid @class value in NodePlan JSON", () -> NodePlan.parseJson((String)nodePlan.toJson()));
    }

    private static class NestedStep
    implements Step {
        @JsonProperty
        private NodePlan nodePlan;

        NestedStep() {
        }

        NestedStep(NodePlan nodePlan) {
            this.nodePlan = nodePlan;
        }

        NodePlan getNodePlan() {
            return this.nodePlan;
        }

        public long getBytesToMove() {
            return 0L;
        }

        public DiskBalancerVolume getDestinationVolume() {
            return null;
        }

        public double getIdealStorage() {
            return 0.0;
        }

        public DiskBalancerVolume getSourceVolume() {
            return null;
        }

        public String getVolumeSetID() {
            return "";
        }

        public String getSizeString(long size) {
            return "";
        }

        public long getMaxDiskErrors() {
            return 0L;
        }

        public long getTolerancePercent() {
            return 0L;
        }

        public long getBandwidth() {
            return 0L;
        }

        public void setTolerancePercent(long tolerancePercent) {
        }

        public void setBandwidth(long bandwidth) {
        }

        public void setMaxDiskErrors(long maxDiskErrors) {
        }
    }
}

