/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util.retry;

import java.time.Duration;
import java.util.List;
import software.amazon.s3.analyticsaccelerator.util.retry.RetryPolicy;
import software.amazon.s3.shaded.dev.failsafe.event.ExecutionAttemptedEvent;

public class RetryPolicyBuilder {
    private final software.amazon.s3.shaded.dev.failsafe.RetryPolicyBuilder<Object> delegateBuilder = software.amazon.s3.shaded.dev.failsafe.RetryPolicy.builder();

    protected RetryPolicyBuilder() {
    }

    public RetryPolicyBuilder withMaxRetries(int maxRetries) {
        this.delegateBuilder.withMaxRetries(maxRetries);
        return this;
    }

    public RetryPolicyBuilder withDelay(Duration delay) {
        this.delegateBuilder.withDelay(delay);
        return this;
    }

    public RetryPolicyBuilder handle(Class<? extends Throwable> exception) {
        this.delegateBuilder.handle((Class<Throwable>)exception);
        return this;
    }

    @SafeVarargs
    public final RetryPolicyBuilder handle(Class<? extends Throwable> ... exceptions) {
        this.delegateBuilder.handle(exceptions);
        return this;
    }

    public final RetryPolicyBuilder handle(List<Class<? extends Throwable>> exceptions) {
        this.delegateBuilder.handle(exceptions);
        return this;
    }

    public RetryPolicyBuilder onRetry(Runnable onRetry) {
        this.delegateBuilder.onRetry((ExecutionAttemptedEvent<R> event) -> onRetry.run());
        return this;
    }

    public RetryPolicy build() {
        software.amazon.s3.shaded.dev.failsafe.RetryPolicy<Object> delegate = this.delegateBuilder.build();
        return new RetryPolicyImpl(delegate);
    }

    private static class RetryPolicyImpl
    implements RetryPolicy {
        private final software.amazon.s3.shaded.dev.failsafe.RetryPolicy<Object> delegate;

        RetryPolicyImpl(software.amazon.s3.shaded.dev.failsafe.RetryPolicy<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public software.amazon.s3.shaded.dev.failsafe.RetryPolicy<Object> getDelegate() {
            return this.delegate;
        }
    }
}

