/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.test.MetricsAsserts;
import org.junit.Test;

public class TestHSync {
    private void checkSyncMetric(MiniDFSCluster cluster, int dn, long value) {
        DataNode datanode = cluster.getDataNodes().get(dn);
        MetricsAsserts.assertCounter((String)"FsyncCount", (long)value, (MetricsRecordBuilder)MetricsAsserts.getMetrics((String)datanode.getMetrics().name()));
    }

    private void checkSyncMetric(MiniDFSCluster cluster, long value) {
        this.checkSyncMetric(cluster, 0, value);
    }

    @Test
    public void testHSync() throws Exception {
        this.testHSyncOperation(false);
    }

    @Test
    public void testHSyncWithAppend() throws Exception {
        this.testHSyncOperation(true);
    }

    private void testHSyncOperation(boolean testWithAppend) throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path p = new Path("/testHSync/foo");
        int len = 65536;
        FSDataOutputStream out = fs.create(p, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK), 4096, (short)1, 65536L, null);
        if (testWithAppend) {
            out.close();
            out = fs.append(p, EnumSet.of(CreateFlag.APPEND, CreateFlag.SYNC_BLOCK), 4096, null);
        }
        out.hflush();
        this.checkSyncMetric(cluster, 0L);
        out.hsync();
        this.checkSyncMetric(cluster, 0L);
        out.write(1);
        this.checkSyncMetric(cluster, 0L);
        out.hsync();
        this.checkSyncMetric(cluster, 1L);
        out.hsync();
        this.checkSyncMetric(cluster, 2L);
        out.hflush();
        this.checkSyncMetric(cluster, 2L);
        out.close();
        this.checkSyncMetric(cluster, 3L);
        out = fs.create(p, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), 4096, (short)1, 65536L, null);
        out.hsync();
        this.checkSyncMetric(cluster, 3L);
        out.write(1);
        this.checkSyncMetric(cluster, 3L);
        out.hsync();
        this.checkSyncMetric(cluster, 4L);
        out.hsync();
        this.checkSyncMetric(cluster, 5L);
        out.close();
        this.checkSyncMetric(cluster, 5L);
        cluster.shutdown();
    }

    @Test
    public void testHSyncBlockBoundary() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path p = new Path("/testHSyncBlockBoundary/foo");
        int len = 65536;
        byte[] fileContents = AppendTestUtil.initBuffer(65536);
        FSDataOutputStream out = fs.create(p, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK), 4096, (short)1, 65536L, null);
        out.write(fileContents, 0, 65536);
        out.hflush();
        this.checkSyncMetric(cluster, 1L);
        out.hsync();
        this.checkSyncMetric(cluster, 1L);
        out.write(1);
        out.hsync();
        this.checkSyncMetric(cluster, 2L);
        out.close();
        this.checkSyncMetric(cluster, 3L);
        cluster.shutdown();
    }

    @Test
    public void testSequenceFileSync() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path p = new Path("/testSequenceFileSync/foo");
        int len = 65536;
        FSDataOutputStream out = fs.create(p, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK), 4096, (short)1, 65536L, null);
        SequenceFile.Writer w = SequenceFile.createWriter((Configuration)new Configuration(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.stream((FSDataOutputStream)out), SequenceFile.Writer.keyClass(RandomDatum.class), SequenceFile.Writer.valueClass(RandomDatum.class), SequenceFile.Writer.compression((SequenceFile.CompressionType)SequenceFile.CompressionType.NONE, (CompressionCodec)new DefaultCodec())});
        w.hflush();
        this.checkSyncMetric(cluster, 0L);
        w.hsync();
        this.checkSyncMetric(cluster, 1L);
        int seed = new Random().nextInt();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        generator.next();
        w.append((Writable)generator.getKey(), (Writable)generator.getValue());
        w.hsync();
        this.checkSyncMetric(cluster, 2L);
        w.close();
        this.checkSyncMetric(cluster, 2L);
        out.close();
        this.checkSyncMetric(cluster, 3L);
        cluster.shutdown();
    }

    @Test
    public void testHSyncWithReplication() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path p = new Path("/testHSyncWithReplication/foo");
        int len = 65536;
        FSDataOutputStream out = fs.create(p, FsPermission.getDefault(), EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE, CreateFlag.SYNC_BLOCK), 4096, (short)3, 65536L, null);
        out.write(1);
        out.hflush();
        this.checkSyncMetric(cluster, 0, 0L);
        this.checkSyncMetric(cluster, 1, 0L);
        this.checkSyncMetric(cluster, 2, 0L);
        out.hsync();
        this.checkSyncMetric(cluster, 0, 1L);
        this.checkSyncMetric(cluster, 1, 1L);
        this.checkSyncMetric(cluster, 2, 1L);
        out.hsync();
        this.checkSyncMetric(cluster, 0, 2L);
        this.checkSyncMetric(cluster, 1, 2L);
        this.checkSyncMetric(cluster, 2, 2L);
        cluster.shutdown();
    }
}

