/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.configuration.injection;

import java.lang.reflect.Field;
import java.util.Set;

public abstract class MockInjectionStrategy {
    private MockInjectionStrategy nextStrategy;

    public static MockInjectionStrategy nop() {
        return new MockInjectionStrategy(){

            @Override
            protected boolean processInjection(Field field, Object fieldOwner, Set<Object> mockCandidates) {
                return false;
            }
        };
    }

    public MockInjectionStrategy thenTry(MockInjectionStrategy strategy) {
        if (this.nextStrategy != null) {
            this.nextStrategy.thenTry(strategy);
        } else {
            this.nextStrategy = strategy;
        }
        return strategy;
    }

    public boolean process(Field onField, Object fieldOwnedBy, Set<Object> mockCandidates) {
        if (this.processInjection(onField, fieldOwnedBy, mockCandidates)) {
            return true;
        }
        return this.relayProcessToNextStrategy(onField, fieldOwnedBy, mockCandidates);
    }

    protected abstract boolean processInjection(Field var1, Object var2, Set<Object> var3);

    private boolean relayProcessToNextStrategy(Field field, Object fieldOwner, Set<Object> mockCandidates) {
        return this.nextStrategy != null && this.nextStrategy.process(field, fieldOwner, mockCandidates);
    }
}

