/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.metrics.CustomResourceMetricValue;
import org.apache.hadoop.yarn.metrics.CustomResourceMetrics;

public class QueueMetricsForCustomResources
extends CustomResourceMetrics {
    private final CustomResourceMetricValue aggregatePreemptedSeconds = new CustomResourceMetricValue();
    private final CustomResourceMetricValue aggregatePreempted = new CustomResourceMetricValue();
    private final CustomResourceMetricValue pending = new CustomResourceMetricValue();
    private final CustomResourceMetricValue reserved = new CustomResourceMetricValue();

    public void increaseReserved(Resource res) {
        this.reserved.increase(res);
    }

    public void decreaseReserved(Resource res) {
        this.reserved.decrease(res);
    }

    public void increasePending(Resource res, int containers) {
        this.pending.increaseWithMultiplier(res, (long)containers);
    }

    public void decreasePending(Resource res) {
        this.pending.decrease(res);
    }

    public void decreasePending(Resource res, int containers) {
        this.pending.decreaseWithMultiplier(res, containers);
    }

    public Map<String, Long> getPendingValues() {
        return this.pending.getValues();
    }

    public Map<String, Long> getReservedValues() {
        return this.reserved.getValues();
    }

    public void increaseAggregatedPreemptedSeconds(Resource res, long seconds) {
        this.aggregatePreemptedSeconds.increaseWithMultiplier(res, seconds);
    }

    public void increaseAggregatedPreempted(Resource res) {
        this.aggregatePreempted.increase(res);
    }

    CustomResourceMetricValue getAggregatePreemptedSeconds() {
        return this.aggregatePreemptedSeconds;
    }
}

