/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.management.model.capabilities.descriptors;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.terracotta.management.model.capabilities.descriptors.Descriptor;

public final class CallDescriptor
implements Descriptor,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String returnType;
    private final List<Parameter> parameters;

    public CallDescriptor(String name, String returnType, Parameter ... parameters) {
        this(name, returnType, Arrays.asList(parameters));
    }

    public CallDescriptor(String name, String returnType, List<Parameter> parameters) {
        this.name = Objects.requireNonNull(name);
        this.returnType = Objects.requireNonNull(returnType);
        this.parameters = Objects.requireNonNull(parameters);
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallDescriptor{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", returnType='").append(this.returnType).append('\'');
        sb.append(", parameters=").append(this.parameters);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallDescriptor that = (CallDescriptor)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.returnType.equals(that.returnType)) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public static final class Parameter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final String type;

        public Parameter(String name, String type) {
            this.name = Objects.requireNonNull(name);
            this.type = Objects.requireNonNull(type);
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Parameter{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", type='").append(this.type).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (!this.name.equals(parameter.name)) {
                return false;
            }
            return this.type.equals(parameter.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

