/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStoreIndexCache;
import software.amazon.s3.analyticsaccelerator.util.BlockKey;
import software.amazon.s3.analyticsaccelerator.util.MetricKey;

public class Block
implements Closeable {
    @Nullable
    private byte[] data;
    @Nullable
    private IOException error;
    private final BlockKey blockKey;
    private final long generation;
    private final BlobStoreIndexCache indexCache;
    private final Metrics aggregatingMetrics;
    private final CountDownLatch dataReadyLatch = new CountDownLatch(1);

    public Block(@NonNull BlockKey blockKey, long generation, @NonNull BlobStoreIndexCache indexCache, @NonNull Metrics aggregatingMetrics) {
        if (blockKey == null) {
            throw new NullPointerException("blockKey is marked non-null but is null");
        }
        if (indexCache == null) {
            throw new NullPointerException("indexCache is marked non-null but is null");
        }
        if (aggregatingMetrics == null) {
            throw new NullPointerException("aggregatingMetrics is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= generation, "`generation` must be non-negative; was: %s", generation);
        this.blockKey = blockKey;
        this.generation = generation;
        this.indexCache = indexCache;
        this.aggregatingMetrics = aggregatingMetrics;
    }

    public int read(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        this.awaitData();
        this.indexCache.recordAccess(this.blockKey);
        int contentOffset = this.posToOffset(pos);
        return Byte.toUnsignedInt(this.data[contentOffset]);
    }

    public int read(byte @NonNull [] buf, int off, int len, long pos) throws IOException {
        if (buf == null) {
            throw new NullPointerException("buf is marked non-null but is null");
        }
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        this.awaitData();
        this.indexCache.recordAccess(this.blockKey);
        int contentOffset = this.posToOffset(pos);
        int available = this.data.length - contentOffset;
        int bytesToCopy = Math.min(len, available);
        if (bytesToCopy >= 0) {
            System.arraycopy(this.data, contentOffset, buf, off, bytesToCopy);
        }
        return bytesToCopy;
    }

    public boolean isDataReady() {
        return this.dataReadyLatch.getCount() == 0L;
    }

    private int posToOffset(long pos) {
        return (int)(pos - this.blockKey.getRange().getStart());
    }

    public void setData(byte[] data) {
        this.data = data;
        this.aggregatingMetrics.add(MetricKey.MEMORY_USAGE, data.length);
        this.indexCache.put(this.blockKey, this.blockKey.getRange().getLength());
        this.dataReadyLatch.countDown();
    }

    public void setError(@NonNull IOException error) {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        this.error = error;
        this.dataReadyLatch.countDown();
    }

    private void awaitData() throws IOException {
        try {
            this.dataReadyLatch.await();
        }
        catch (InterruptedException e) {
            throw new IOException("Error while reading data. Read interrupted while waiting for data", e);
        }
        if (this.error != null) {
            throw this.error;
        }
        if (this.data == null) {
            throw new IOException("Error while reading data. Block data is null after successful await");
        }
    }

    public int getLength() {
        return this.blockKey.getRange().getLength();
    }

    @Override
    public void close() throws IOException {
        this.data = null;
    }

    @Generated
    public BlockKey getBlockKey() {
        return this.blockKey;
    }

    @Generated
    public long getGeneration() {
        return this.generation;
    }
}

