/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.junit.Assert;
import org.junit.Test;

public class TestCoderUtil {
    private final int numInputs = 9;
    private final int chunkSize = 1024;

    @Test
    public void testGetEmptyChunk() {
        byte[] ret = CoderUtil.getEmptyChunk((int)1024);
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)0L, (long)ret[i]);
        }
    }

    @Test
    public void testResetBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(2048).putInt(1234);
        buf.position(0);
        ByteBuffer ret = CoderUtil.resetBuffer((ByteBuffer)buf, (int)1024);
        for (int i = 0; i < 1024; ++i) {
            Assert.assertEquals((long)0L, (long)ret.getInt(i));
        }
        byte[] inputs = ByteBuffer.allocate(9).putInt(1234).array();
        CoderUtil.resetBuffer((byte[])inputs, (int)0, (int)9);
        for (int i = 0; i < 9; ++i) {
            Assert.assertEquals((long)0L, (long)inputs[i]);
        }
    }

    @Test
    public void testGetValidIndexes() {
        byte[][] inputs = new byte[9][];
        inputs[0] = new byte[1024];
        inputs[1] = new byte[1024];
        inputs[7] = new byte[1024];
        inputs[8] = new byte[1024];
        int[] validIndexes = CoderUtil.getValidIndexes((Object[])inputs);
        Assert.assertEquals((long)4L, (long)validIndexes.length);
        Assert.assertEquals((long)0L, (long)validIndexes[0]);
        Assert.assertEquals((long)1L, (long)validIndexes[1]);
        Assert.assertEquals((long)7L, (long)validIndexes[2]);
        Assert.assertEquals((long)8L, (long)validIndexes[3]);
    }

    @Test
    public void testNoValidIndexes() {
        byte[][] inputs = new byte[9][];
        for (int i = 0; i < 9; ++i) {
            inputs[i] = null;
        }
        int[] validIndexes = CoderUtil.getValidIndexes((Object[])inputs);
        Assert.assertEquals((long)0L, (long)validIndexes.length);
    }

    @Test
    public void testGetNullIndexes() {
        byte[][] inputs = new byte[9][];
        inputs[0] = new byte[1024];
        inputs[1] = new byte[1024];
        for (int i = 2; i < 7; ++i) {
            inputs[i] = null;
        }
        inputs[7] = new byte[1024];
        inputs[8] = new byte[1024];
        int[] nullIndexes = CoderUtil.getNullIndexes((Object[])inputs);
        Assert.assertEquals((long)2L, (long)nullIndexes[0]);
        Assert.assertEquals((long)3L, (long)nullIndexes[1]);
        Assert.assertEquals((long)4L, (long)nullIndexes[2]);
        Assert.assertEquals((long)5L, (long)nullIndexes[3]);
        Assert.assertEquals((long)6L, (long)nullIndexes[4]);
    }

    @Test
    public void testFindFirstValidInput() {
        byte[][] inputs = new byte[9][];
        inputs[8] = ByteBuffer.allocate(4).putInt(1234).array();
        byte[] firstValidInput = (byte[])CoderUtil.findFirstValidInput((Object[])inputs);
        Assert.assertEquals((Object)firstValidInput, (Object)inputs[8]);
    }

    @Test(expected=HadoopIllegalArgumentException.class)
    public void testNoValidInput() {
        byte[][] inputs = new byte[9][];
        CoderUtil.findFirstValidInput((Object[])inputs);
    }
}

