/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.CachedBlock;
import org.apache.hadoop.util.IntrusiveCollection;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCachedBlocksList {
    public static final Logger LOG = LoggerFactory.getLogger(TestCachedBlocksList.class);

    @Test(timeout=60000L)
    public void testSingleList() {
        DatanodeDescriptor dn = new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "abcd", 5000, 5001, 5002, 5003));
        CachedBlock[] blocks = new CachedBlock[]{new CachedBlock(0L, 1, true), new CachedBlock(1L, 1, true), new CachedBlock(2L, 1, true)};
        Assert.assertTrue((String)"expected pending cached list to start off empty.", (!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((String)"expected cached list to start off empty.", (!dn.getCached().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((String)"expected pending uncached list to start off empty.", (!dn.getPendingUncached().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dn.getCached().add((IntrusiveCollection.Element)blocks[0]));
        Assert.assertTrue((String)"expected pending cached list to still be empty.", (!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertEquals((String)"failed to insert blocks[0]", (Object)blocks[0], dn.getCached().iterator().next());
        Assert.assertTrue((String)"expected pending uncached list to still be empty.", (!dn.getPendingUncached().iterator().hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dn.getCached().add((IntrusiveCollection.Element)blocks[1]));
        Iterator iter = dn.getCached().iterator();
        Assert.assertEquals((Object)blocks[0], iter.next());
        Assert.assertEquals((Object)blocks[1], iter.next());
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dn.getCached().addFirst((IntrusiveCollection.Element)blocks[2]));
        iter = dn.getCached().iterator();
        Assert.assertEquals((Object)blocks[2], iter.next());
        Assert.assertEquals((Object)blocks[0], iter.next());
        Assert.assertEquals((Object)blocks[1], iter.next());
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)dn.getCached().remove((Object)blocks[0]));
        iter = dn.getCached().iterator();
        Assert.assertEquals((Object)blocks[2], iter.next());
        Assert.assertEquals((Object)blocks[1], iter.next());
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        dn.getCached().clear();
        Assert.assertTrue((String)"expected cached list to be empty after clear.", (!dn.getPendingCached().iterator().hasNext() ? 1 : 0) != 0);
    }

    private void testAddElementsToList(DatanodeDescriptor.CachedBlocksList list, CachedBlock[] blocks) {
        Assert.assertTrue((String)"expected list to start off empty.", (!list.iterator().hasNext() ? 1 : 0) != 0);
        for (CachedBlock block : blocks) {
            Assert.assertTrue((boolean)list.add((IntrusiveCollection.Element)block));
        }
    }

    private void testRemoveElementsFromList(Random r, DatanodeDescriptor.CachedBlocksList list, CachedBlock[] blocks) {
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Assert.assertEquals((Object)blocks[i], iter.next());
            ++i;
        }
        if (r.nextBoolean()) {
            LOG.info("Removing via iterator");
            iter = list.iterator();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        } else {
            LOG.info("Removing in pseudo-random order");
            CachedBlock[] remainingBlocks = Arrays.copyOf(blocks, blocks.length);
            int removed = 0;
            while (removed < remainingBlocks.length) {
                int toRemove = r.nextInt(remainingBlocks.length);
                if (remainingBlocks[toRemove] == null) continue;
                Assert.assertTrue((boolean)list.remove((Object)remainingBlocks[toRemove]));
                remainingBlocks[toRemove] = null;
                ++removed;
            }
        }
        Assert.assertTrue((String)"expected list to be empty after everything was removed.", (!list.iterator().hasNext() ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMultipleLists() {
        DatanodeDescriptor[] datanodes = new DatanodeDescriptor[]{new DatanodeDescriptor(new DatanodeID("127.0.0.1", "localhost", "abcd", 5000, 5001, 5002, 5003)), new DatanodeDescriptor(new DatanodeID("127.0.1.1", "localhost", "efgh", 6000, 6001, 6002, 6003))};
        DatanodeDescriptor.CachedBlocksList[] lists = new DatanodeDescriptor.CachedBlocksList[]{datanodes[0].getPendingCached(), datanodes[0].getCached(), datanodes[1].getPendingCached(), datanodes[1].getCached(), datanodes[1].getPendingUncached()};
        int NUM_BLOCKS = 8000;
        CachedBlock[] blocks = new CachedBlock[8000];
        for (int i = 0; i < 8000; ++i) {
            blocks[i] = new CachedBlock((long)i, (short)i, true);
        }
        Random r = new Random(654L);
        for (DatanodeDescriptor.CachedBlocksList list : lists) {
            this.testAddElementsToList(list, blocks);
        }
        for (DatanodeDescriptor.CachedBlocksList list : lists) {
            this.testRemoveElementsFromList(r, list, blocks);
        }
    }
}

