/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server;

import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.scheduler.ResourceRequestSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerAllocationHistory {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientRelayer.class);
    private int maxEntryCount;
    private Queue<Map.Entry<Long, Long>> relaxableG = new LinkedList<Map.Entry<Long, Long>>();

    public ContainerAllocationHistory(Configuration conf) {
        this.maxEntryCount = conf.getInt("yarn.federation.amrmproxy.allocation.history.max.entry", 100);
    }

    public synchronized void addAllocationEntry(Container container, ResourceRequestSet requestSet, long fulfillTimeStamp, long fulfillLatency) {
        if (!requestSet.isANYRelaxable()) {
            LOG.info("allocation history ignoring {}, relax locality is false", (Object)container);
            return;
        }
        this.relaxableG.add(new AbstractMap.SimpleEntry<Long, Long>(fulfillTimeStamp, fulfillLatency));
        if (this.relaxableG.size() > this.maxEntryCount) {
            this.relaxableG.remove();
        }
    }
}

