/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.utils;

import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreInvalidInputException;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKey;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterStoreToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FederationRouterRMTokenInputValidator {
    private static final Logger LOG = LoggerFactory.getLogger(FederationRouterRMTokenInputValidator.class);

    private FederationRouterRMTokenInputValidator() {
    }

    public static void validate(RouterRMTokenRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing RouterRMToken Request. Please try again by specifying a router rm token information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        RouterStoreToken storeToken = request.getRouterStoreToken();
        if (storeToken == null) {
            String message = "Missing RouterStoreToken. Please try again by specifying a router rm token information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        try {
            YARNDelegationTokenIdentifier identifier = storeToken.getTokenIdentifier();
            if (identifier == null) {
                String message = "Missing YARNDelegationTokenIdentifier. Please try again by specifying a router rm token information.";
                LOG.warn(message);
                throw new FederationStateStoreInvalidInputException(message);
            }
        }
        catch (Exception e) {
            throw new FederationStateStoreInvalidInputException(e);
        }
    }

    public static void validate(RouterMasterKeyRequest request) throws FederationStateStoreInvalidInputException {
        if (request == null) {
            String message = "Missing RouterMasterKey Request. Please try again by specifying a router master key request information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
        RouterMasterKey masterKey = request.getRouterMasterKey();
        if (masterKey == null) {
            String message = "Missing RouterMasterKey. Please try again by specifying a router master key information.";
            LOG.warn(message);
            throw new FederationStateStoreInvalidInputException(message);
        }
    }
}

